/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import java.net.URI;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.oauth2.client.OAuth2AuthCodeAuthorization;
import org.dmfs.oauth2.client.http.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.oauth2.client.http.requests.AbstractAccessTokenRequest;
import org.dmfs.oauth2.client.utils.ImmutableEntry;

public final class AuthorizationCodeTokenRequest
extends AbstractAccessTokenRequest {
    private final ImmutableEntry GRANT_TYPE = new ImmutableEntry("grant_type", "authorization_code");
    private final OAuth2AuthCodeAuthorization mAuthorization;
    private final URI mRedirectUri;

    public AuthorizationCodeTokenRequest(OAuth2AuthCodeAuthorization authorization, URI redirectUri) {
        super(authorization.scope());
        this.mAuthorization = authorization;
        this.mRedirectUri = redirectUri;
    }

    public HttpRequestEntity requestEntity() {
        return new XWwwFormUrlEncodedEntity(this.GRANT_TYPE, new ImmutableEntry("code", this.mAuthorization.code()), new ImmutableEntry("redirect_uri", this.mRedirectUri.toASCIIString()));
    }
}

