/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.oauth2.client.http.requests.AbstractAccessTokenRequest;
import org.dmfs.oauth2.client.scope.EmptyScope;
import org.dmfs.oauth2.client.utils.ImmutableEntry;

public final class ClientCredentialsTokenRequest
extends AbstractAccessTokenRequest {
    private final ImmutableEntry GRANT_TYPE = new ImmutableEntry("grant_type", "client_credentials");
    private final OAuth2Scope mScope;

    public ClientCredentialsTokenRequest() {
        this(EmptyScope.INSTANCE);
    }

    public ClientCredentialsTokenRequest(OAuth2Scope scope) {
        super(scope);
        this.mScope = scope;
    }

    public HttpRequestEntity requestEntity() {
        if (this.mScope.isEmpty()) {
            return new XWwwFormUrlEncodedEntity(this.GRANT_TYPE);
        }
        return new XWwwFormUrlEncodedEntity(this.GRANT_TYPE, new ImmutableEntry("scope", this.mScope.toString()));
    }
}

