/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.oauth2.client.http.requests.AbstractAccessTokenRequest;
import org.dmfs.oauth2.client.utils.ImmutableEntry;

public final class ResourceOwnerPasswordTokenRequest
extends AbstractAccessTokenRequest {
    private final ImmutableEntry GRANT_TYPE = new ImmutableEntry("grant_type", "password");
    private final String mUsername;
    private final String mPassword;
    private final OAuth2Scope mScope;

    public ResourceOwnerPasswordTokenRequest(OAuth2Scope scope, String username, String password) {
        super(scope);
        this.mUsername = username;
        this.mPassword = password;
        this.mScope = scope;
    }

    public HttpRequestEntity requestEntity() {
        return new XWwwFormUrlEncodedEntity(this.GRANT_TYPE, new ImmutableEntry("username", this.mUsername), new ImmutableEntry("password", this.mPassword), new ImmutableEntry("scope", this.mScope.toString()));
    }
}

