/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.responsehandlers;

import java.io.IOException;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.responsehandlers.StringResponseHandler;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StructuredMediaType;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.errors.TokenRequestError;
import org.json.JSONException;
import org.json.JSONObject;

public final class TokenErrorResponseHandler
implements HttpResponseHandler<OAuth2AccessToken> {
    private static final MediaType APPLICATION_JSON = new StructuredMediaType("application", "json");

    public OAuth2AccessToken handleResponse(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        if (!APPLICATION_JSON.equals(response.responseEntity().contentType())) {
            throw new ProtocolException(String.format("Illegal response content-type %s, exected %s", response.responseEntity().contentType(), APPLICATION_JSON));
        }
        String responseString = new StringResponseHandler("UTF-8").handleResponse(response);
        try {
            throw new TokenRequestError(new JSONObject(responseString));
        }
        catch (JSONException e) {
            throw new ProtocolException(String.format("Can't decode JSON response %s", responseString), (Throwable)e);
        }
    }
}

