/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.responsehandlers;

import java.io.IOException;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.responsehandlers.StringResponseHandler;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StructuredMediaType;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.tokens.JsonAccessToken;
import org.json.JSONException;
import org.json.JSONObject;

public final class TokenResponseHandler
implements HttpResponseHandler<OAuth2AccessToken> {
    private static final MediaType APPLICATION_JSON = new StructuredMediaType("application", "json");
    private final OAuth2Scope mScope;

    public TokenResponseHandler(OAuth2Scope scope) {
        this.mScope = scope;
    }

    public OAuth2AccessToken handleResponse(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        if (!APPLICATION_JSON.equals(response.responseEntity().contentType())) {
            throw new ProtocolException(String.format("Illegal response content-type %s, exected %s", response.responseEntity().contentType(), APPLICATION_JSON));
        }
        String responseString = new StringResponseHandler("UTF-8").handleResponse(response);
        try {
            return new JsonAccessToken(new JSONObject(responseString), this.mScope);
        }
        catch (JSONException e) {
            throw new ProtocolException(String.format("Can't decode JSON response %s", responseString), (Throwable)e);
        }
    }
}

