/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.tokens;

import java.net.URI;
import java.util.NoSuchElementException;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.parameters.BasicParameterType;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parametrized;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.httpessentials.types.UrlFormEncodedKeyValues;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.scope.StringScope;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Duration;

public final class ImplicitGrantAccessToken
implements OAuth2AccessToken {
    private static final ParameterType<OAuth2Scope> SCOPE = new BasicParameterType("scope", (EntityConverter)new EntityConverter<OAuth2Scope>(){

        public OAuth2Scope value(String valueString) {
            return new StringScope(valueString);
        }

        public String valueString(OAuth2Scope value) {
            return value.toString();
        }
    });
    private static final ParameterType<String> ACCESS_TOKEN = new BasicParameterType("access_token", (EntityConverter)PlainStringHeaderConverter.INSTANCE);
    private static final ParameterType<String> TOKEN_TYPE = new BasicParameterType("token_type", (EntityConverter)PlainStringHeaderConverter.INSTANCE);
    private static final ParameterType<String> STATE = new BasicParameterType("state", (EntityConverter)PlainStringHeaderConverter.INSTANCE);
    private static final ParameterType<Duration> EXPIRES_IN = new BasicParameterType("expires_in", (EntityConverter)new EntityConverter<Duration>(){

        public Duration value(String valueString) {
            return new Duration(1, 0, Integer.parseInt(valueString));
        }

        public String valueString(Duration value) {
            return value.toString();
        }
    });
    private final Parametrized mRedirectUriFragment;
    private final DateTime mIssueDate;
    private final OAuth2Scope mScope;
    private final Duration mDefaultExpiresIn;

    public ImplicitGrantAccessToken(URI redirectUri, OAuth2Scope scope, String state, Duration defaultExpiresIn) throws ProtocolException {
        this.mRedirectUriFragment = new UrlFormEncodedKeyValues(redirectUri.getFragment());
        if (!state.equals(this.mRedirectUriFragment.firstParameter(STATE, (Object)""))) {
            throw new ProtocolException("State in redirect uri doesn't match the original state!");
        }
        this.mIssueDate = DateTime.now();
        this.mScope = scope;
        this.mDefaultExpiresIn = defaultExpiresIn;
    }

    @Override
    public String accessToken() throws ProtocolException {
        if (!this.mRedirectUriFragment.hasParameter(ACCESS_TOKEN)) {
            throw new ProtocolException(String.format("Missing access_token in fragment '%s'", this.mRedirectUriFragment.toString()));
        }
        return (String)this.mRedirectUriFragment.firstParameter(ACCESS_TOKEN, (Object)"").value();
    }

    @Override
    public String tokenType() throws ProtocolException {
        if (!this.mRedirectUriFragment.hasParameter(TOKEN_TYPE)) {
            throw new ProtocolException(String.format("Missing token_type in fragment '%s'", this.mRedirectUriFragment.toString()));
        }
        return (String)this.mRedirectUriFragment.firstParameter(TOKEN_TYPE, (Object)"").value();
    }

    @Override
    public boolean hasRefreshToken() {
        return false;
    }

    @Override
    public String refreshToken() throws ProtocolException {
        throw new NoSuchElementException("Implicit grants do no issue refresh tokens");
    }

    @Override
    public DateTime expirationDate() throws ProtocolException {
        return this.mIssueDate.addDuration((Duration)this.mRedirectUriFragment.firstParameter(EXPIRES_IN, (Object)this.mDefaultExpiresIn).value());
    }

    @Override
    public OAuth2Scope scope() throws ProtocolException {
        return (OAuth2Scope)this.mRedirectUriFragment.firstParameter(SCOPE, (Object)this.mScope).value();
    }
}

