/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.tokens;

import java.util.NoSuchElementException;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Duration;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonAccessToken
implements OAuth2AccessToken {
    private final JSONObject mTokenResponse;
    private final OAuth2Scope mScope;
    private final DateTime mIssueDate;

    public JsonAccessToken(JSONObject tokenResponse, OAuth2Scope scope) {
        this.mScope = scope;
        this.mTokenResponse = tokenResponse;
        this.mIssueDate = DateTime.now();
    }

    @Override
    public String accessToken() throws ProtocolException {
        try {
            return this.mTokenResponse.getString("access_token");
        }
        catch (JSONException e) {
            throw new ProtocolException("Can't read access_token from token response", (Throwable)e);
        }
    }

    @Override
    public String tokenType() throws ProtocolException {
        try {
            return this.mTokenResponse.getString("token_type");
        }
        catch (JSONException e) {
            throw new ProtocolException("Can't read token_type from token response", (Throwable)e);
        }
    }

    @Override
    public boolean hasRefreshToken() {
        return this.mTokenResponse.optString("refresh_token", null) != null;
    }

    @Override
    public String refreshToken() throws ProtocolException {
        if (!this.hasRefreshToken()) {
            throw new NoSuchElementException("No refresh token found");
        }
        try {
            return this.mTokenResponse.getString("refresh_token");
        }
        catch (JSONException e) {
            throw new ProtocolException("Can't read refresh_token from token response", (Throwable)e);
        }
    }

    @Override
    public DateTime expirationDate() throws ProtocolException {
        try {
            return this.mIssueDate.addDuration(new Duration(1, 0, this.mTokenResponse.getInt("expires_in")));
        }
        catch (JSONException e) {
            throw new ProtocolException("Can't read expires_in from token response", (Throwable)e);
        }
    }

    @Override
    public OAuth2Scope scope() throws ProtocolException {
        return this.mScope;
    }
}

