/*
 * Decompiled with CFR 0.152.
 */
package org.dmonix.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javascalautils.TryCompanion;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dmonix.servlet.Request;
import org.dmonix.servlet.RequestParser;
import org.dmonix.servlet.Response;
import org.dmonix.servlet.ResponseBuilder;

public abstract class JSONServlet
extends HttpServlet
implements RequestParser,
ResponseBuilder {
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeResponse(resp, TryCompanion.Try(() -> this.get(new Request(req))));
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeResponse(resp, TryCompanion.Try(() -> this.delete(new Request(req))));
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeResponse(resp, TryCompanion.Try(() -> this.post(new Request(req))));
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeResponse(resp, TryCompanion.Try(() -> this.put(new Request(req))));
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Set methods = Arrays.stream(this.getClass().getDeclaredMethods()).map(Method::getName).collect(Collectors.toSet());
        StringBuilder allow = new StringBuilder();
        allow.append("OPTIONS");
        allow.append(", ");
        allow.append("TRACE");
        allow.append(", ");
        if (methods.contains("get")) {
            allow.append("GET");
            allow.append(", ");
            allow.append("HEAD");
        }
        if (methods.contains("post")) {
            allow.append(", ");
            allow.append("POST");
        }
        if (methods.contains("put")) {
            allow.append(", ");
            allow.append("PUT");
        }
        if (methods.contains("delete")) {
            allow.append(", ");
            allow.append("DELETE");
        }
        resp.setHeader("Allow", allow.toString());
    }

    protected Response get(Request request) throws ServletException, IOException {
        return this.ErrorResponseUnsupportedOperation();
    }

    protected Response delete(Request request) throws ServletException, IOException {
        return this.ErrorResponseUnsupportedOperation();
    }

    protected Response post(Request request) throws ServletException, IOException {
        return this.ErrorResponseUnsupportedOperation();
    }

    protected Response put(Request request) throws ServletException, IOException {
        return this.ErrorResponseUnsupportedOperation();
    }
}

