/*
 * Decompiled with CFR 0.152.
 */
package org.dmonix.servlet;

import com.google.gson.Gson;
import java.io.IOException;
import javascalautils.Option;
import javascalautils.OptionCompanion;
import javascalautils.Try;
import javax.servlet.http.HttpServletResponse;
import org.dmonix.servlet.Response;

public interface ResponseBuilder {
    public static final Gson gson = new Gson();

    default public Response EmptyResponse(int responseCode) {
        return new Response(responseCode, "");
    }

    default public Response AcceptedResponse() {
        return this.EmptyResponse(202);
    }

    default public Response CreatedResponse() {
        return this.EmptyResponse(201);
    }

    default public Response ObjectResponse(Object object) {
        return this.ObjectResponse(object, "UTF-8");
    }

    default public Response ObjectResponse(Object object, String charEncoding) {
        return new Response(200, gson.toJson(object), (Option<String>)OptionCompanion.Some((Object)("application/json;charset=" + charEncoding)), (Option<String>)OptionCompanion.Some((Object)charEncoding));
    }

    default public Response ErrorResponse(Throwable throwable) {
        return this.ErrorResponse(500, throwable.getMessage());
    }

    default public Response ErrorResponse(int responseCode, String message) {
        return new Response(responseCode, message);
    }

    default public Response ErrorResponseNotFound(String message) {
        return this.ErrorResponse(404, message);
    }

    default public Response ErrorResponseMissingPath() {
        return this.ErrorResponse(400, "Missing path");
    }

    default public Response ErrorResponseResourceAlreadyExists(String path) {
        return this.ErrorResponse(403, "The resource depicted by [" + path + "] already exists");
    }

    default public Response ErrorResponseUnsupportedOperation() {
        return this.ErrorResponse(405, "Method not allowed");
    }

    default public void writeResponse(HttpServletResponse resp, Try<Response> response) throws IOException {
        this.writeResponse(resp, (Response)response.recover(this::ErrorResponse).orNull());
    }

    default public void writeResponse(HttpServletResponse resp, Response response) throws IOException {
        resp.setStatus(response.responseCode);
        response.headers().forEach((arg_0, arg_1) -> ((HttpServletResponse)resp).setHeader(arg_0, arg_1));
        response.mediaType.forEach(arg_0 -> ((HttpServletResponse)resp).setContentType(arg_0));
        response.charEncoding.forEach(arg_0 -> ((HttpServletResponse)resp).setCharacterEncoding(arg_0));
        resp.getWriter().write(response.message);
    }
}

