/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.desktop.client;

import com.fasterxml.jackson.databind.SerializationFeature;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.commons.beanutils.BeanUtils;
import org.dominokit.rest.shared.request.AbstractRequestAsyncSender;
import org.dominokit.rest.shared.request.FailedResponseBean;
import org.dominokit.rest.shared.request.ServerRequest;
import org.dominokit.rest.shared.request.ServerRequestEventFactory;
import org.dominokit.rest.shared.request.ServiceRootMatcher;
import org.dominokit.rest.shared.request.service.annotations.ServiceRoot;

public class DesktopRequestAsyncSender
extends AbstractRequestAsyncSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesktopRequestAsyncSender.class);
    public static final int RESPONSE_TYPE_INDEX = 1;
    private final WebClient webClient = WebClient.create((Vertx)Vertx.vertx());
    private String csrfToken;

    public DesktopRequestAsyncSender(ServerRequestEventFactory requestEventFactory) {
        super(requestEventFactory);
    }

    protected void sendRequest(ServerRequest request, ServerRequestEventFactory requestEventFactory) {
        HttpMethod method = this.getHttpMethod(request);
        String absoluteURI = this.buildPath(request);
        HttpRequest httpRequest = this.webClient.requestAbs(method, absoluteURI);
        if (Objects.nonNull(this.csrfToken)) {
            httpRequest.putHeader("X-XSRF-TOKEN", this.csrfToken);
        }
        request.headers().forEach((arg_0, arg_1) -> ((HttpRequest)httpRequest).putHeader(arg_0, arg_1));
        httpRequest.putHeader("Content-Type", "application/json");
        if (HttpMethod.POST.equals((Object)method) || HttpMethod.PUT.equals((Object)method) || HttpMethod.PATCH.equals((Object)method)) {
            httpRequest.putHeader("Accept", "application/json");
        }
        ParameterizedType parameterizedType = (ParameterizedType)request.getClass().getGenericSuperclass();
        Type responseType = parameterizedType.getActualTypeArguments()[1];
        try {
            Class<?> clazz = Class.forName(responseType.getTypeName());
            httpRequest.sendJson(request.requestBean(), event -> {
                if (event.succeeded()) {
                    this.csrfToken = ((HttpResponse)event.result()).headers().getAll("Set-Cookie").stream().filter(header -> header.startsWith("XSRF-TOKEN")).map(header -> header.substring(0, header.indexOf(";")).replace("XSRF-TOKEN=", "")).findFirst().orElse(this.csrfToken);
                    requestEventFactory.makeSuccess(request, Json.decodeValue((Buffer)((Buffer)((HttpResponse)event.result()).body()), (Class)clazz)).fire();
                } else {
                    requestEventFactory.makeFailed(request, new FailedResponseBean(event.cause())).fire();
                }
            });
        }
        catch (ClassNotFoundException e) {
            requestEventFactory.makeFailed(request, new FailedResponseBean((Throwable)e));
        }
    }

    private HttpMethod getHttpMethod(ServerRequest request) {
        if (Objects.nonNull(request.getClass().getAnnotation(GET.class))) {
            return HttpMethod.GET;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(POST.class))) {
            return HttpMethod.POST;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(PUT.class))) {
            return HttpMethod.PUT;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(DELETE.class))) {
            return HttpMethod.DELETE;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(PATCH.class))) {
            return HttpMethod.PATCH;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(OPTIONS.class))) {
            return HttpMethod.OPTIONS;
        }
        if (Objects.nonNull(request.getClass().getAnnotation(HEAD.class))) {
            return HttpMethod.HEAD;
        }
        return HttpMethod.GET;
    }

    private String buildPath(ServerRequest request) {
        Path pathAnnotation = request.getClass().getAnnotation(Path.class);
        ServiceRoot serviceRootAnnotation = request.getClass().getAnnotation(ServiceRoot.class);
        String path = this.formattedPath(this.getPathParams(pathAnnotation.value()), request.requestBean(), pathAnnotation.value());
        String serviceRoot = serviceRootAnnotation.value().isEmpty() ? ServiceRootMatcher.matchedServiceRoot((String)path) : serviceRootAnnotation.value();
        if (serviceRoot.endsWith("/") || pathAnnotation.value().startsWith("/")) {
            return (serviceRoot + path).replace("//", "/");
        }
        return serviceRoot + "/" + path;
    }

    private String formattedPath(Collection<String> pathParams, Object arguments, String path) {
        String[] processedPath = new String[]{path};
        pathParams.forEach(p -> {
            try {
                String value = this.isNested((String)p) ? this.getNestedValue(arguments, (String)p) : BeanUtils.getProperty((Object)arguments, (String)p);
                processedPath[0] = processedPath[0].replace("{" + p + "}", Objects.isNull(value) ? "" : value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                processedPath[0] = processedPath[0].replace("{" + p + "}", (CharSequence)p);
            }
        });
        return processedPath[0];
    }

    private String getNestedValue(Object arguments, String p) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (!this.isNestedNull(arguments, p.split("\\."))) {
            return BeanUtils.getProperty((Object)arguments, (String)p);
        }
        return "";
    }

    private boolean isNested(String p) {
        return p.contains(".");
    }

    private boolean isNestedNull(Object arguments, String[] nestedParts) {
        return IntStream.range(0, nestedParts.length - 1).anyMatch(i -> {
            try {
                return Objects.isNull(BeanUtils.getProperty((Object)arguments, (String)nestedParts[i]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error((Object)"Error while getting nested value", (Throwable)e);
                return false;
            }
        });
    }

    private Collection<String> getPathParams(String path) {
        HashSet<String> paramsNames = new HashSet<String>();
        Matcher pathParamMatcher = Pattern.compile("\\{(.*?)\\}").matcher(path);
        while (pathParamMatcher.find()) {
            paramsNames.add(pathParamMatcher.group().replace("{", "").replace("}", ""));
        }
        return paramsNames;
    }

    static {
        Json.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

