/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.desktop.client;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.dominokit.domino.api.client.ClientApp;
import org.dominokit.domino.history.AppHistory;
import org.dominokit.domino.history.DefaultNormalizedToken;
import org.dominokit.domino.history.DominoDirectState;
import org.dominokit.domino.history.DominoHistory;
import org.dominokit.domino.history.HistoryInterceptor;
import org.dominokit.domino.history.HistoryToken;
import org.dominokit.domino.history.NormalizedToken;
import org.dominokit.domino.history.StateHistoryToken;
import org.dominokit.domino.history.StateToken;
import org.dominokit.domino.history.TokenFilter;
import org.dominokit.domino.history.TokenParameter;

public class DesktopStateHistory
implements AppHistory {
    private Set<HistoryListener> listeners = new HashSet<HistoryListener>();
    private final String rootPath;

    public DesktopStateHistory() {
        this("");
    }

    public DesktopStateHistory(String rootPath) {
        this.rootPath = rootPath;
    }

    public void fireCurrentStateHistory() {
    }

    public DominoHistory.DirectState listen(DominoHistory.StateListener listener) {
        return this.listen(TokenFilter.any(), listener, false);
    }

    public DominoHistory.DirectState listen(DominoHistory.StateListener listener, boolean removeOnComplete) {
        return this.listen(TokenFilter.any(), listener, removeOnComplete);
    }

    public DominoHistory.DirectState listen(TokenFilter tokenFilter, DominoHistory.StateListener listener) {
        return this.listen(tokenFilter, listener, false);
    }

    public DominoHistory.DirectState listen(TokenFilter tokenFilter, DominoHistory.StateListener listener, boolean removeOnComplete) {
        this.listeners.add(new HistoryListener(listener, tokenFilter, removeOnComplete));
        return new DominoDirectState(tokenFilter, this.currentState(), listener);
    }

    public void removeListener(DominoHistory.StateListener stateListener) {
        this.listeners.remove(stateListener);
    }

    private DominoHistory.State currentState() {
        return new DominoHistoryState("", "", this.stateData(this.state()));
    }

    private DominoHistory.State state() {
        return new DominoHistory.State(){

            public String rootPath() {
                return ClientApp.make().getHistory().getRootPath();
            }

            public HistoryToken token() {
                return new StateHistoryToken("");
            }

            public Optional<String> data() {
                return Optional.of("");
            }

            public String title() {
                return "";
            }

            public NormalizedToken normalizedToken() {
                return new DefaultNormalizedToken((HistoryToken)new StateHistoryToken(""));
            }

            public void setNormalizedToken(NormalizedToken normalizedToken) {
            }
        };
    }

    private String stateData(DominoHistory.State state) {
        return state.data().isPresent() ? (String)state.data().get() : "";
    }

    public void back() {
    }

    public void forward() {
    }

    public void pushState(StateToken token) {
    }

    public void replaceState(StateToken token) {
    }

    public void fireState(StateToken token) {
    }

    public void pushState(StateToken token, TokenParameter ... parameters) {
    }

    public void fireState(StateToken token, TokenParameter ... parameters) {
    }

    public void fireCurrentStateHistory(String title) {
    }

    public int getHistoryEntriesCount() {
        return 0;
    }

    public HistoryToken currentToken() {
        return new StateHistoryToken("");
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void addInterceptor(HistoryInterceptor interceptor) {
    }

    public void removeInterceptor(HistoryInterceptor interceptor) {
    }

    private class DominoHistoryState
    implements DominoHistory.State {
        private final HistoryToken token;
        private final String data;
        private final String title;

        public DominoHistoryState(String token, String title, String data) {
            this.token = new StateHistoryToken(token);
            this.data = data;
            this.title = title;
        }

        public String rootPath() {
            return DesktopStateHistory.this.rootPath;
        }

        public HistoryToken token() {
            return this.token;
        }

        public Optional<String> data() {
            return Optional.of(this.data);
        }

        public String title() {
            return this.title;
        }

        public NormalizedToken normalizedToken() {
            return new DefaultNormalizedToken((HistoryToken)new StateHistoryToken(this.token.value()));
        }

        public void setNormalizedToken(NormalizedToken normalizedToken) {
        }
    }

    private class HistoryListener {
        private final DominoHistory.StateListener listener;
        private final TokenFilter tokenFilter;
        private final boolean removeOnComplete;

        private HistoryListener(DominoHistory.StateListener listener, TokenFilter tokenFilter) {
            this.listener = listener;
            this.tokenFilter = tokenFilter;
            this.removeOnComplete = false;
        }

        private HistoryListener(DominoHistory.StateListener listener, TokenFilter tokenFilter, boolean removeOnComplete) {
            this.listener = listener;
            this.tokenFilter = tokenFilter;
            this.removeOnComplete = removeOnComplete;
        }
    }
}

