/*
 * Copyright 2008 The GWT Project Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.event.shared;

/**
 * An object that implements this interface has a collection of event handlers associated with it.
 */
public interface HasHandlers {

  /**
   * Fires the given event to the handlers listening to the event's type.
   *
   * <p>Any exceptions thrown by handlers will be bundled into a {@link UmbrellaException} and then
   * re-thrown after all handlers have completed. An exception thrown by a handler will not prevent
   * other handlers from executing.
   *
   * @param event the event
   */
  void fireEvent(Event<?> event);
}
