/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.arq.gobackn;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PendingWriteQueue;
import java.util.LinkedList;
import java.util.List;
import org.drasyl.handler.arq.gobackn.GoBackNArqData;
import org.drasyl.handler.arq.gobackn.Window;
import org.drasyl.util.Preconditions;

class PendingQueueWindow
implements Window {
    private final PendingWriteQueue pendingWriteQueue;
    private final List<Window.Frame> queue;
    private final int capacity;

    PendingQueueWindow(ChannelHandlerContext ctx, int capacity) {
        this.capacity = Preconditions.requirePositive((int)capacity);
        this.pendingWriteQueue = new PendingWriteQueue(ctx);
        this.queue = new LinkedList<Window.Frame>();
    }

    @Override
    public boolean add(GoBackNArqData msg, ChannelPromise promise) {
        if (this.queue.size() < this.capacity) {
            this.queue.add(new Window.Frame(msg, promise));
            this.pendingWriteQueue.add((Object)msg, promise);
            return true;
        }
        return false;
    }

    @Override
    public ChannelPromise remove() {
        if (!this.queue.isEmpty()) {
            this.queue.remove(0);
            return this.pendingWriteQueue.remove();
        }
        return null;
    }

    @Override
    public List<Window.Frame> getQueue() {
        return List.copyOf(this.queue);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int getFreeSpace() {
        return this.capacity - this.queue.size();
    }

    @Override
    public void removeAndFailAll(Throwable cause) {
        this.queue.clear();
        this.pendingWriteQueue.removeAndFailAll(cause);
    }
}

