/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.arq.gobackn;

import io.netty.channel.ChannelPromise;
import java.util.LinkedList;
import java.util.List;
import org.drasyl.handler.arq.gobackn.GoBackNArqData;
import org.drasyl.handler.arq.gobackn.Window;
import org.drasyl.util.Preconditions;

public class SimpleWindow
implements Window {
    private final int capacity;
    private final List<Window.Frame> queue;

    public SimpleWindow(int capacity) {
        this.capacity = Preconditions.requirePositive((int)capacity);
        this.queue = new LinkedList<Window.Frame>();
    }

    @Override
    public boolean add(GoBackNArqData msg, ChannelPromise promise) {
        if (this.queue.size() < this.capacity) {
            this.queue.add(new Window.Frame(msg, promise));
            return true;
        }
        return false;
    }

    @Override
    public ChannelPromise remove() {
        if (!this.queue.isEmpty()) {
            Window.Frame f = this.queue.remove(0);
            f.getMsg().release();
            return f.getPromise();
        }
        return null;
    }

    @Override
    public List<Window.Frame> getQueue() {
        return List.copyOf(this.queue);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int getFreeSpace() {
        return this.capacity - this.queue.size();
    }

    @Override
    public void removeAndFailAll(Throwable cause) {
        for (Window.Frame f : this.queue) {
            f.getMsg().release();
            f.getPromise().tryFailure(cause);
        }
        this.queue.clear();
    }
}

