/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.arq.stopandwait;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.util.List;
import org.drasyl.handler.arq.stopandwait.StopAndWaitArqAck;
import org.drasyl.handler.arq.stopandwait.StopAndWaitArqData;
import org.drasyl.handler.arq.stopandwait.StopAndWaitArqMessage;

public final class StopAndWaitArqCodec
extends MessageToMessageCodec<ByteBuf, StopAndWaitArqMessage> {
    public static final int MAGIC_NUMBER_DATA = 523370708;
    public static final int MAGIC_NUMBER_ACK = 523370709;
    public static final int MIN_MESSAGE_LENGTH = 5;

    protected void encode(ChannelHandlerContext ctx, StopAndWaitArqMessage msg, List<Object> out) throws EncoderException {
        if (msg instanceof StopAndWaitArqData) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(523370708);
            buf.writeBoolean(msg.sequenceNo());
            buf.writeBytes(((StopAndWaitArqData)msg).content());
            out.add(buf);
        } else if (msg instanceof StopAndWaitArqAck) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(523370709);
            buf.writeBoolean(msg.sequenceNo());
            out.add(buf);
        } else {
            throw new EncoderException("Unknown StopAndWaitMessage type: " + StringUtil.simpleClassName((Object)msg));
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 5) {
            in.markReaderIndex();
            int magicNumber = in.readInt();
            boolean sequenceNo = in.readBoolean();
            if (523370708 == magicNumber) {
                out.add(new StopAndWaitArqData(sequenceNo, in.retain()));
            } else if (523370709 == magicNumber) {
                out.add(sequenceNo ? StopAndWaitArqAck.STOP_AND_WAIT_ACK_1 : StopAndWaitArqAck.STOP_AND_WAIT_ACK_0);
            } else {
                in.resetReaderIndex();
                out.add(in.retain());
            }
        } else {
            out.add(in.retain());
        }
    }
}

