/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.drasyl.util.ThrowingBiConsumer;
import org.drasyl.util.ThrowingBiFunction;
import org.drasyl.util.internal.UnstableApi;

public class JacksonCodec<T>
extends ByteToMessageCodec<T> {
    private final ThrowingBiConsumer<OutputStream, Object, IOException> jacksonWriter;
    private final ThrowingBiFunction<InputStream, Class<T>, T, IOException> jacksonReader;
    private final Class<T> clazz;

    JacksonCodec(ThrowingBiConsumer<OutputStream, Object, IOException> jacksonWriter, ThrowingBiFunction<InputStream, Class<T>, T, IOException> jacksonReader, Class<T> clazz) {
        super(clazz);
        this.jacksonWriter = Objects.requireNonNull(jacksonWriter);
        this.jacksonReader = Objects.requireNonNull(jacksonReader);
        this.clazz = Objects.requireNonNull(clazz);
    }

    @UnstableApi
    public JacksonCodec(ObjectMapper mapper, Class<T> clazz) {
        this((ThrowingBiConsumer<OutputStream, Object, IOException>)((ThrowingBiConsumer)(arg_0, arg_1) -> ((ObjectMapper)mapper).writeValue(arg_0, arg_1)), (arg_0, arg_1) -> ((ObjectMapper)mapper).readValue(arg_0, arg_1), clazz);
    }

    public JacksonCodec(Class<T> clazz) {
        this(new ObjectMapper(), clazz);
    }

    protected void encode(ChannelHandlerContext ctx, T msg, ByteBuf out) throws IOException {
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(out);){
            this.jacksonWriter.accept((Object)outputStream, msg);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(in);){
            out.add(this.jacksonReader.apply((Object)inputStream, this.clazz));
        }
    }
}

