/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.drasyl.util.Preconditions;

public class MaxLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    public MaxLengthFrameDecoder(int maxFrameLength) {
        this.maxFrameLength = Preconditions.requirePositive((int)maxFrameLength);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        out.add(in.readRetainedSlice(Math.min(in.readableBytes(), this.maxFrameLength)));
    }
}

