/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.connection;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PendingWriteQueue;
import java.nio.channels.ClosedChannelException;
import org.drasyl.handler.connection.ConnectionHandshakeCompleted;

public class ConnectionHandshakePendWritesHandler
extends ChannelDuplexHandler {
    private PendingWriteQueue pendingWrites;
    private boolean doFlush;

    ConnectionHandshakePendWritesHandler(PendingWriteQueue pendingWrites, boolean doFlush) {
        this.pendingWrites = pendingWrites;
        this.doFlush = doFlush;
    }

    public ConnectionHandshakePendWritesHandler() {
        this(null, false);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.pendingWrites = new PendingWriteQueue(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndFailAll((Throwable)new Exception(ConnectionHandshakePendWritesHandler.class.getSimpleName() + " that has pend this write has been removed from channel before connection handshake was completed."));
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.pendingWrites.add(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) {
        this.doFlush = true;
        ctx.flush();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.pendingWrites.removeAndFailAll((Throwable)new ClosedChannelException());
        this.pendingWrites = null;
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof ConnectionHandshakeCompleted) {
            this.pendingWrites.removeAndWriteAll();
            if (this.doFlush) {
                ctx.flush();
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.fireUserEventTriggered(evt);
    }
}

