/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import org.drasyl.util.Preconditions;

public class ConnectionHandshakeSegment
extends DefaultByteBufHolder {
    public static final long MIN_SEQ_NO = 0L;
    public static final long MAX_SEQ_NO = 0xFFFFFFFFL;
    private static final byte URG = 32;
    private static final byte ACK = 16;
    private static final byte PSH = 8;
    private static final byte RST = 4;
    private static final byte SYN = 2;
    private static final byte FIN = 1;
    private final long seq;
    private final long ack;
    private final byte ctl;

    public ConnectionHandshakeSegment(long seq, long ack, byte ctl, ByteBuf data) {
        super(data);
        this.seq = Preconditions.requireInRange((long)seq, (long)0L, (long)0xFFFFFFFFL);
        this.ack = Preconditions.requireInRange((long)ack, (long)0L, (long)0xFFFFFFFFL);
        this.ctl = ctl;
    }

    public long seq() {
        return this.seq;
    }

    public long ack() {
        return this.ack;
    }

    public int ctl() {
        return this.ctl;
    }

    public boolean isUrg() {
        return (this.ctl & 0x20) != 0;
    }

    public boolean isAck() {
        return (this.ctl & 0x10) != 0;
    }

    public boolean isOnlyAck() {
        return this.ctl == 16;
    }

    public boolean isPsh() {
        return (this.ctl & 8) != 0;
    }

    public boolean isRst() {
        return (this.ctl & 4) != 0;
    }

    public boolean isSyn() {
        return (this.ctl & 2) != 0;
    }

    public boolean isFin() {
        return (this.ctl & 1) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectionHandshakeSegment segment = (ConnectionHandshakeSegment)((Object)o);
        return this.seq == segment.seq && this.ack == segment.ack && this.ctl == segment.ctl;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seq, this.ack, this.ctl);
    }

    public String toString() {
        ArrayList<String> controlBitLabels = new ArrayList<String>();
        if (this.isUrg()) {
            controlBitLabels.add("URG");
        }
        if (this.isPsh()) {
            controlBitLabels.add("PSH");
        }
        if (this.isRst()) {
            controlBitLabels.add("RST");
        }
        if (this.isFin()) {
            controlBitLabels.add("FIN");
        }
        if (this.isSyn()) {
            controlBitLabels.add("SYN");
        }
        if (this.isAck()) {
            controlBitLabels.add("ACK");
        }
        return "<SEQ=" + this.seq + "><ACK=" + this.ack + "><CTL=" + String.join((CharSequence)",", controlBitLabels) + ">";
    }

    public static ConnectionHandshakeSegment ack(long seq, long ack) {
        return new ConnectionHandshakeSegment(seq, ack, 16, Unpooled.EMPTY_BUFFER);
    }

    public static ConnectionHandshakeSegment rst(long seq) {
        return new ConnectionHandshakeSegment(seq, 0L, 4, Unpooled.EMPTY_BUFFER);
    }

    public static ConnectionHandshakeSegment syn(long seq) {
        return new ConnectionHandshakeSegment(seq, 0L, 2, Unpooled.EMPTY_BUFFER);
    }

    public static ConnectionHandshakeSegment pshAck(long seq, long ack, ByteBuf data) {
        return new ConnectionHandshakeSegment(seq, ack, 24, data);
    }

    public static ConnectionHandshakeSegment rstAck(long seq, long ack) {
        return new ConnectionHandshakeSegment(seq, ack, 20, Unpooled.EMPTY_BUFFER);
    }

    public static ConnectionHandshakeSegment synAck(long seq, long ack) {
        return new ConnectionHandshakeSegment(seq, ack, 18, Unpooled.EMPTY_BUFFER);
    }

    public static ConnectionHandshakeSegment finAck(long seq, long ack) {
        return new ConnectionHandshakeSegment(seq, ack, 17, Unpooled.EMPTY_BUFFER);
    }
}

