/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.drasyl.handler.dht.chord.LocalChordNode;
import org.drasyl.util.Preconditions;
import org.drasyl.util.RandomUtil;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class ChordHousekeepingHandler
extends ChannelInboundHandlerAdapter {
    public static final long DEFAULT_CHECK_INTERVAL = 500L;
    private static final Logger LOG = LoggerFactory.getLogger(ChordHousekeepingHandler.class);
    private final long checkIntervalMillis;
    private final LocalChordNode localNode;
    private Future<?> askPredecessorTaskFuture;
    private Future<?> fixFingersTask;
    private Future<?> stabilizeTaskFuture;

    public ChordHousekeepingHandler(long checkIntervalMillis, LocalChordNode localNode) {
        this.checkIntervalMillis = Preconditions.requirePositive((long)checkIntervalMillis);
        this.localNode = Objects.requireNonNull(localNode);
    }

    public ChordHousekeepingHandler(LocalChordNode localNode) {
        this(500L, localNode);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.scheduleAskPredecessorTask(ctx);
            this.scheduleFixFingersTask(ctx);
            this.scheduleStabilizeTask(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.cancelAskPredecessorTask();
        this.cancelFixFingersTask();
        this.cancelStabilizeTask();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.scheduleAskPredecessorTask(ctx);
        this.scheduleFixFingersTask(ctx);
        this.scheduleStabilizeTask(ctx);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.cancelAskPredecessorTask();
        this.cancelFixFingersTask();
        this.cancelStabilizeTask();
        ctx.fireChannelInactive();
    }

    private void scheduleAskPredecessorTask(ChannelHandlerContext ctx) {
        this.askPredecessorTaskFuture = ctx.executor().schedule(() -> {
            LOG.trace("Check if our predecessor (if present) is still alive.");
            this.localNode.checkIfPredecessorIsAlive().addListener((GenericFutureListener)((FutureListener)future -> this.scheduleAskPredecessorTask(ctx)));
        }, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelAskPredecessorTask() {
        if (this.askPredecessorTaskFuture != null) {
            this.askPredecessorTaskFuture.cancel(false);
            this.askPredecessorTaskFuture = null;
        }
    }

    private void scheduleFixFingersTask(ChannelHandlerContext ctx) {
        this.fixFingersTask = ctx.executor().schedule(() -> {
            int i = RandomUtil.randomInt((int)2, (int)32);
            this.localNode.fixFinger(i).addListener((GenericFutureListener)((FutureListener)future -> this.scheduleFixFingersTask(ctx)));
        }, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelFixFingersTask() {
        if (this.fixFingersTask != null) {
            this.fixFingersTask.cancel(false);
            this.fixFingersTask = null;
        }
    }

    private void scheduleStabilizeTask(ChannelHandlerContext ctx) {
        this.stabilizeTaskFuture = ctx.executor().schedule(() -> {
            LOG.debug("Ask successor for its predecessor and determine if we should update or delete our successor.");
            this.localNode.stabilize().addListener((GenericFutureListener)((FutureListener)future -> this.scheduleStabilizeTask(ctx)));
        }, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelStabilizeTask() {
        if (this.stabilizeTaskFuture != null) {
            this.stabilizeTaskFuture.cancel(false);
            this.stabilizeTaskFuture = null;
        }
    }
}

