/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Objects;
import org.drasyl.handler.dht.chord.ChordException;
import org.drasyl.handler.dht.chord.ChordLookup;
import org.drasyl.handler.dht.chord.ChordResponse;
import org.drasyl.handler.dht.chord.ChordUtil;
import org.drasyl.handler.dht.chord.LocalChordNode;
import org.drasyl.handler.dht.chord.RemoteChordNode;
import org.drasyl.handler.rmi.RmiClientHandler;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class ChordLookupHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChordLookupHandler.class);
    private final RmiClientHandler client;

    public ChordLookupHandler(RmiClientHandler client) {
        this.client = Objects.requireNonNull(client);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ChordLookup) {
            long id = ((ChordLookup)msg).getId();
            DrasylAddress contact = ((ChordLookup)msg).getContact();
            boolean doStableCheck = ((ChordLookup)msg).doStableCheck();
            RemoteChordNode contactNode = this.client.lookup(LocalChordNode.BIND_NAME, RemoteChordNode.class, (SocketAddress)contact);
            if (doStableCheck) {
                LOG.info("Check first if contact node `{}` is stable.", (Object)contact);
                ChordLookupHandler.doStableCheck(ctx, id, promise, contactNode);
            } else {
                ChordLookupHandler.doLookup(ctx, id, promise, contactNode);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    private static void doStableCheck(ChannelHandlerContext ctx, long id, ChannelPromise promise, RemoteChordNode contactNode) {
        contactNode.isStable().addListener((GenericFutureListener)((FutureListener)future -> {
            if (future.isSuccess()) {
                if (((Boolean)future.getNow()).booleanValue()) {
                    LOG.info("Contact node is stable.");
                    if (!promise.isDone()) {
                        ChordLookupHandler.doLookup(ctx, id, promise, contactNode);
                    } else {
                        LOG.debug("Abort as Promise has been cancelled.");
                    }
                } else {
                    LOG.warn("Contact node is not stable.");
                    promise.tryFailure((Throwable)new ChordException("Contact node is not stable. Please try again later."));
                }
            } else {
                LOG.warn("Unable to reach contact node:", future.cause());
                promise.tryFailure((Throwable)new ChordException("Unable to reach contact node. Please try an other contact node.", future.cause()));
            }
        }));
    }

    private static void doLookup(ChannelHandlerContext ctx, long id, ChannelPromise promise, RemoteChordNode contactNode) {
        LOG.info("Do lookup for id `{}` ({}).", (Object)ChordUtil.chordIdHex(id), (Object)ChordUtil.chordIdPosition(id));
        contactNode.findSuccessor(id).addListener((GenericFutureListener)((FutureListener)future -> {
            if (future.isSuccess()) {
                LOG.debug("Lookup done. Id `{}` ({}) has resolved to address `{}` ({}).", new Object[]{ChordUtil.chordIdHex(id), ChordUtil.chordIdPosition(id), future.getNow(), ChordUtil.chordIdPosition(future.getNow())});
                ctx.fireChannelRead((Object)ChordResponse.of(id, (DrasylAddress)future.getNow()));
                promise.trySuccess();
            } else {
                LOG.warn("Lookup failed:", future.cause());
                promise.tryFailure(future.cause());
            }
        }));
    }
}

