/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import java.nio.ByteBuffer;
import org.drasyl.crypto.Hashing;
import org.drasyl.crypto.HexUtil;
import org.drasyl.handler.dht.chord.LocalChordNode;
import org.drasyl.handler.rmi.RmiUtil;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.identity.IdentityPublicKey;
import org.drasyl.util.Preconditions;

public final class ChordUtil {
    private static final long[] POWER_OF_TWO;

    private ChordUtil() {
    }

    public static long chordId(Object o) {
        int hashCode = o.hashCode();
        byte[] bytes = ByteBuffer.allocate(4).putInt(hashCode).array();
        return ByteBuffer.allocate(8).putInt(0).put(Hashing.sha256((byte[][])new byte[][]{bytes}), 0, 4).position(0).getLong();
    }

    public static String chordIdHex(long id) {
        ByteBuffer buf = ByteBuffer.allocate(8).putLong(id).position(4);
        byte[] a = new byte[buf.position()];
        buf.get(a);
        return HexUtil.bytesToHex((byte[])a);
    }

    public static String chordIdHex(Object o) {
        return ChordUtil.chordIdHex(ChordUtil.chordId(o));
    }

    public static String chordIdPosition(long id) {
        return id * 100L / POWER_OF_TWO[32] + "%";
    }

    public static String chordIdPosition(Object o) {
        return ChordUtil.chordIdPosition(ChordUtil.chordId(o));
    }

    public static long ithFingerStart(long baseId, int i) {
        return (baseId + POWER_OF_TWO[Preconditions.requireInRange((int)i, (int)1, (int)32) - 1]) % POWER_OF_TWO[32];
    }

    public static long ithFingerStart(Object o, int i) {
        return ChordUtil.ithFingerStart(ChordUtil.chordId(o), i);
    }

    public static long relativeChordId(long aId, long bId) {
        long ret = aId - bId;
        if (ret < 0L) {
            ret += POWER_OF_TWO[32];
        }
        return ret;
    }

    public static long relativeChordId(long a, Object b) {
        return ChordUtil.relativeChordId(a, ChordUtil.chordId(b));
    }

    public static long relativeChordId(Object a, long b) {
        return ChordUtil.relativeChordId(ChordUtil.chordId(a), b);
    }

    public static long relativeChordId(Object a, Object b) {
        return ChordUtil.relativeChordId(a, ChordUtil.chordId(b));
    }

    static {
        RmiUtil.OBJECT_MAPPER.addMixIn(IdentityPublicKey.class, LocalChordNode.IdentityPublicKeyMixin.class);
        RmiUtil.OBJECT_MAPPER.addMixIn(DrasylAddress.class, LocalChordNode.DrasylAddressMixin.class);
        POWER_OF_TWO = new long[33];
        long value = 1L;
        for (int i = 0; i < POWER_OF_TWO.length; ++i) {
            ChordUtil.POWER_OF_TWO[i] = value;
            value *= 2L;
        }
    }
}

