/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.SucceededFuture;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import org.drasyl.handler.dht.chord.ChordException;
import org.drasyl.handler.dht.chord.ChordFingerTable;
import org.drasyl.handler.dht.chord.ChordUtil;
import org.drasyl.handler.dht.chord.RemoteChordNode;
import org.drasyl.handler.rmi.RmiClientHandler;
import org.drasyl.handler.rmi.annotation.RmiCaller;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.identity.IdentityPublicKey;
import org.drasyl.util.FutureComposer;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class LocalChordNode
implements RemoteChordNode {
    public static final String BIND_NAME = RemoteChordNode.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(LocalChordNode.class);
    private final ChordFingerTable fingerTable;
    private final RmiClientHandler client;
    private final EventLoopGroup group = new DefaultEventLoopGroup(1);
    @RmiCaller
    private DrasylAddress caller;
    private final DrasylAddress localAddress;
    private DrasylAddress predecessor;

    public LocalChordNode(DrasylAddress localAddress, ChordFingerTable fingerTable, RmiClientHandler client) {
        this.localAddress = Objects.requireNonNull(localAddress);
        this.fingerTable = Objects.requireNonNull(fingerTable);
        this.client = Objects.requireNonNull(client);
    }

    public LocalChordNode(DrasylAddress address, RmiClientHandler client) {
        this(address, new ChordFingerTable(address), client);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOCAL:        " + this.localAddress + " " + ChordUtil.chordIdHex(this.localAddress) + " (" + ChordUtil.chordIdPosition(this.localAddress) + ")");
        sb.append(System.lineSeparator());
        sb.append("PREDECESSOR:  " + this.predecessor + " " + (String)(this.predecessor != null ? ChordUtil.chordIdHex(this.predecessor) + " (" + ChordUtil.chordIdPosition(this.predecessor) + ")" : ""));
        sb.append(System.lineSeparator());
        sb.append("FINGER TABLE:");
        sb.append(System.lineSeparator());
        sb.append(this.fingerTable.toString());
        return sb.toString();
    }

    @Override
    public Future<Void> checkAlive() {
        LOG.debug("checkAlive {}", (Object)this.caller);
        return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, null);
    }

    @Override
    public Future<DrasylAddress> getPredecessor() {
        if (this.predecessor != null) {
            return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Object)this.predecessor);
        }
        return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, null);
    }

    @Override
    public Future<DrasylAddress> getSuccessor() {
        if (this.fingerTable.hasSuccessor()) {
            return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Object)this.fingerTable.getSuccessor());
        }
        return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, null);
    }

    @Override
    public Future<Void> offerAsPredecessor() {
        LOG.debug("Notified by `{}`.", (Object)this.caller);
        if (this.predecessor == null || this.localAddress.equals(this.predecessor)) {
            LOG.info("Set predecessor to `{}`.", (Object)this.caller);
            this.predecessor = this.caller;
        } else {
            long localRelativeDd = ChordUtil.relativeChordId((Object)this.localAddress, (Object)this.predecessor);
            long newPreRelativeId = ChordUtil.relativeChordId((Object)this.caller, (Object)this.predecessor);
            if (newPreRelativeId > 0L && newPreRelativeId < localRelativeDd) {
                LOG.info("Set predecessor `{}`.", (Object)this.caller);
                this.predecessor = this.caller;
            }
        }
        return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, null);
    }

    private FutureComposer<DrasylAddress> composableFindSuccessor(long id) {
        LOG.debug("Find successor of `{}` ({}) by asking id's predecessor for its successor.", () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id));
        DrasylAddress ret = this.fingerTable.getSuccessor();
        return this.findPredecessor(id).then(future -> {
            DrasylAddress pre = (DrasylAddress)future.getNow();
            if (!Objects.equals(pre, this.localAddress)) {
                if (pre != null) {
                    LOG.debug("Predecessor of `{}` ({}) is `{}` ({}).", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> pre, () -> ChordUtil.chordIdPosition(pre)});
                    return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)pre).getSuccessor());
                }
                LOG.debug("Request predecessor of id `{}` ({}) failed. Fail back to `{}` ({}).", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> this.localAddress});
                return FutureComposer.composeSucceededFuture((Object)this.localAddress);
            }
            return FutureComposer.composeSucceededFuture((Object)ret);
        }).then(future -> {
            DrasylAddress ret1 = (DrasylAddress)future.getNow();
            if (ret1 == null) {
                LOG.debug("We're successor of `{}` ({}): `{}` ({})", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> this.localAddress, () -> ChordUtil.chordIdPosition(this.localAddress)});
                return FutureComposer.composeSucceededFuture((Object)this.localAddress);
            }
            LOG.debug("Successor of `{}` ({}) is `{}` ({})", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> ret1, () -> ChordUtil.chordIdPosition(ret1)});
            return FutureComposer.composeSucceededFuture((Object)ret1);
        });
    }

    @Override
    public Future<DrasylAddress> findSuccessor(long id) {
        LOG.debug("findSuccessor({})", () -> ChordUtil.chordIdHex(id));
        return this.composableFindSuccessor(id).finish((EventExecutor)this.group.next());
    }

    @Override
    public Future<Boolean> isStable() {
        return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Object)(this.predecessor == null && this.fingerTable.getSuccessor() == null || this.predecessor != null && this.fingerTable.getSuccessor() != null ? 1 : 0));
    }

    private FutureComposer<DrasylAddress> findPredecessor(long id) {
        LOG.debug("Find predecessor of `{}` ({}).", () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id));
        DrasylAddress myAddress = this.localAddress;
        DrasylAddress mySuccessor = this.fingerTable.getSuccessor();
        long findIdRelativeId = ChordUtil.relativeChordId(id, (Object)myAddress);
        long mySuccessorRelativeId = mySuccessor == null ? 0L : ChordUtil.relativeChordId((Object)mySuccessor, (Object)myAddress);
        return this.findPredecessorRecursive(id, myAddress, findIdRelativeId, mySuccessorRelativeId, this.localAddress);
    }

    private FutureComposer<DrasylAddress> findPredecessorRecursive(long id, DrasylAddress currentNode, long findIdRelativeId, long currentNodeSuccessorsRelativeId, DrasylAddress mostRecentlyAlive) {
        if (findIdRelativeId > 0L && findIdRelativeId <= currentNodeSuccessorsRelativeId) {
            LOG.debug("Predecessor of `{}` ({}) is `{}` ({})", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> currentNode, () -> ChordUtil.chordIdPosition(currentNode)});
            return FutureComposer.composeSucceededFuture((Object)currentNode);
        }
        if (Objects.equals(currentNode, this.localAddress)) {
            return this.findMyClosest(id, currentNode, findIdRelativeId, currentNodeSuccessorsRelativeId, mostRecentlyAlive);
        }
        return this.findPeersClosest(id, currentNode, findIdRelativeId, currentNodeSuccessorsRelativeId, mostRecentlyAlive);
    }

    private FutureComposer<DrasylAddress> findMyClosest(long id, DrasylAddress currentNode, long findIdRelativeId, long currentNodeSuccessorsRelativeId, DrasylAddress mostRecentlyAlive) {
        LOG.debug("Find predecessor of `{}` ({}) by looking up my finger table.", () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id));
        return this.composableFindClosestFingerPreceding(id).then(future -> {
            DrasylAddress finger = (DrasylAddress)future.getNow();
            if (currentNode.equals(finger)) {
                return FutureComposer.composeSucceededFuture((Object)finger);
            }
            LOG.debug("Closest finger preceding `{}` ({}) is `{}` ({}). Now ask finger to find predecessor.", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> finger, () -> ChordUtil.chordIdPosition(finger)});
            return this.findPredecessorRecursive(id, finger, findIdRelativeId, currentNodeSuccessorsRelativeId, mostRecentlyAlive);
        });
    }

    private FutureComposer<DrasylAddress> findPeersClosest(long id, DrasylAddress currentNode, long findIdRelativeId, long currentNodeSuccessorsRelativeId, DrasylAddress mostRecentlyAlive) {
        LOG.debug("Find predecessor of `{}` ({}) by looking up the finger table of `{}` ({}).", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> currentNode, () -> currentNode != null ? ChordUtil.chordIdPosition(currentNode) : currentNode});
        FutureComposer lookupComposer = currentNode != null ? FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)currentNode).findClosestFingerPreceding(id)) : FutureComposer.composeSucceededFuture(null);
        return lookupComposer.then(future -> {
            DrasylAddress closest = (DrasylAddress)future.getNow();
            LOG.debug("`{}` ({}) returned `{}` ({}) as closest finger preceding `{}` ({}).", new Supplier[]{() -> currentNode, () -> currentNode != null ? ChordUtil.chordIdPosition(currentNode) : currentNode, () -> closest, () -> closest != null ? ChordUtil.chordIdPosition(closest) : null, () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id)});
            if (closest == null) {
                LOG.debug("Got no response from `{}` ({}). Try to get successor of `{}` ({}).", new Supplier[]{() -> currentNode, () -> currentNode != null ? ChordUtil.chordIdPosition(currentNode) : currentNode, () -> mostRecentlyAlive, () -> ChordUtil.chordIdPosition(mostRecentlyAlive)});
                return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)mostRecentlyAlive).getSuccessor()).then(future1 -> {
                    DrasylAddress mostRecentlySuccessor = (DrasylAddress)future1.getNow();
                    if (mostRecentlySuccessor == null) {
                        LOG.debug("Got no response from `{}` ({}). Return us.", new Supplier[]{() -> mostRecentlyAlive, () -> ChordUtil.chordIdPosition(mostRecentlyAlive), () -> this.localAddress});
                        return FutureComposer.composeSucceededFuture((Object)this.localAddress);
                    }
                    LOG.debug("Find predecessor of `{}` ({}) by asking `{}` ({}).", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> mostRecentlySuccessor, () -> ChordUtil.chordIdPosition(mostRecentlySuccessor)});
                    return this.findPredecessorRecursive(id, mostRecentlyAlive, findIdRelativeId, currentNodeSuccessorsRelativeId, mostRecentlyAlive);
                });
            }
            if (closest.equals(currentNode)) {
                return FutureComposer.composeSucceededFuture((Object)closest);
            }
            return this.requestClosestSuccessor(id, currentNode, closest);
        });
    }

    private FutureComposer<DrasylAddress> requestClosestSuccessor(long findId, DrasylAddress currentNode, DrasylAddress closest) {
        return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)closest).getSuccessor()).then(future -> {
            DrasylAddress closestSuccessor = (DrasylAddress)future.getNow();
            if (closestSuccessor != null) {
                if (currentNode.equals(closest)) {
                    return FutureComposer.composeSucceededFuture((Object)closest);
                }
                long closestSuccessorsRelativeId = ChordUtil.relativeChordId((Object)closestSuccessor, (Object)closest);
                long findIdsRelativeId = ChordUtil.relativeChordId(findId, ChordUtil.chordId(closest));
                return this.findPredecessorRecursive(findId, closest, findIdsRelativeId, closestSuccessorsRelativeId, currentNode);
            }
            return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)currentNode).getSuccessor());
        });
    }

    private FutureComposer<DrasylAddress> composableFindClosestFingerPreceding(long id) {
        LOG.debug("Find closest finger preceding `{}` ({}). Go down starting from {}th finger.", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> 32});
        return this.findClosestFingerPrecedingRecursive(id, 32);
    }

    @Override
    public Future<DrasylAddress> findClosestFingerPreceding(long id) {
        return this.composableFindClosestFingerPreceding(id).finish((EventExecutor)this.group.next());
    }

    private FutureComposer<DrasylAddress> findClosestFingerPrecedingRecursive(long id, int i) {
        if (i == 0) {
            LOG.debug("Reached {}th finger. We're closest to `{}` ({}).", new Supplier[]{() -> i, () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id)});
            return FutureComposer.composeSucceededFuture((Object)this.localAddress);
        }
        return FutureComposer.composeSucceededFuture((Object)this.fingerTable.get(i)).then(future -> {
            DrasylAddress ithFinger = (DrasylAddress)future.getNow();
            if (ithFinger != null) {
                long ithFingerId = ChordUtil.chordId(ithFinger);
                long ithFingerRelativeId = ChordUtil.relativeChordId(ithFingerId, (Object)this.localAddress);
                long findIdRelative = ChordUtil.relativeChordId(id, (Object)this.localAddress);
                if (ithFingerRelativeId > 0L && ithFingerRelativeId < findIdRelative) {
                    LOG.debug("{}th finger `{}` ({}) is closest to precede `{}` ({}).", new Supplier[]{() -> i, () -> ithFinger, () -> ChordUtil.chordIdPosition(ithFinger), () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id)});
                    if (this.localAddress.equals(ithFinger)) {
                        LOG.debug("That is me. Finger is for sure alive ;).");
                        return FutureComposer.composeSucceededFuture((Object)ithFinger);
                    }
                    LOG.debug("Check if {}th finger `{}` ({}) is still alive.", new Supplier[]{() -> i, () -> ithFinger, () -> ChordUtil.chordIdPosition(ithFinger)});
                    return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)ithFinger).checkAlive()).then(future2 -> {
                        if (future2.isSuccess()) {
                            LOG.debug("{}th finger `{}` ({}) is still alive.", new Supplier[]{() -> i, () -> ithFinger, () -> ChordUtil.chordIdPosition(ithFinger)});
                            return FutureComposer.composeSucceededFuture((Object)ithFinger);
                        }
                        int nextI = i - 1;
                        LOG.debug("{}th finger `{}` ({}) is no longer alive. Remote it from finger table and go to {}th finger.", new Supplier[]{() -> i, () -> ithFinger, () -> ChordUtil.chordIdPosition(ithFinger), () -> nextI});
                        this.fingerTable.removePeer(ithFinger);
                        return this.findClosestFingerPrecedingRecursive(id, nextI);
                    });
                }
                int nextI = i - 1;
                LOG.debug("{}th finger `{}` ({}) is not preceding `{}` ({}). Go to {}th finger.", new Supplier[]{() -> i, () -> ithFinger, () -> ChordUtil.chordIdPosition(ithFinger), () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> nextI});
                return this.findClosestFingerPrecedingRecursive(id, nextI);
            }
            int nextI = i - 1;
            LOG.debug("{}th finger does not exist. Go to {}th finger.", () -> i, () -> nextI);
            return this.findClosestFingerPrecedingRecursive(id, nextI);
        });
    }

    private FutureComposer<Void> composableUpdateIthFinger(int i, DrasylAddress value, RmiClientHandler client) {
        if (this.fingerTable.updateIthFinger(i, value)) {
            return FutureComposer.composeFuture(client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)value).offerAsPredecessor());
        }
        return FutureComposer.composeSucceededFuture();
    }

    public Future<Void> join(DrasylAddress contact) {
        return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)contact).findSuccessor(ChordUtil.chordId(this.localAddress))).then(future -> {
            if (future.isSuccess()) {
                DrasylAddress successor = (DrasylAddress)future.getNow();
                LOG.debug("Successor for our id `{}` is `{}`.", (Object)ChordUtil.chordIdHex(this.localAddress), (Object)successor);
                LOG.info("Set successor to `{}`.", (Object)successor);
                return this.composableUpdateIthFinger(1, successor, this.client);
            }
            LOG.error("Failed to join DHT ring `{}`:", (Object)contact, (Object)future.cause());
            return FutureComposer.composeFailedFuture((Throwable)new ChordException("Failed to join DHT ring.", future.cause()));
        }).finish((EventExecutor)this.group.next());
    }

    public Future<Void> checkIfPredecessorIsAlive() {
        if (this.predecessor != null) {
            return this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)this.predecessor).checkAlive().addListener((GenericFutureListener)((FutureListener)future -> {
                if (!future.isSuccess()) {
                    LOG.debug("Our predecessor `{}` is not longer alive. Clear predecessor.", (Object)this.predecessor);
                    this.predecessor = null;
                }
            }));
        }
        return this.group.next().newSucceededFuture(null);
    }

    public Future<Void> stabilize() {
        LOG.debug("stabilize()");
        DrasylAddress successor = this.fingerTable.getSuccessor();
        FutureComposer voidFuture = successor == null || successor.equals(this.localAddress) ? this.fillSuccessor() : FutureComposer.composeSucceededFuture();
        return voidFuture.then(future -> {
            if (successor != null && !successor.equals(this.localAddress)) {
                LOG.debug("Check if successor `{}` ({}) has still us a predecessor.", () -> successor, () -> ChordUtil.chordIdPosition(successor));
                return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)successor).getPredecessor()).then(future2 -> {
                    DrasylAddress x = (DrasylAddress)future2.getNow();
                    if (x == null) {
                        LOG.debug("Bad connection with successor `{}`. Delete successor from finger table.", (Object)successor);
                        return this.deleteSuccessor();
                    }
                    if (!x.equals(successor)) {
                        if (x.equals(this.localAddress)) {
                            LOG.debug("Successor `{}` ({}) has still us as predecessor. All fine.", () -> successor, () -> ChordUtil.chordIdPosition(successor));
                        } else {
                            LOG.debug("Successor's predecessor is `{}` ({}).", () -> x, () -> ChordUtil.chordIdPosition(x));
                        }
                        long localId = ChordUtil.chordId(this.localAddress);
                        long successorRelativeId = ChordUtil.relativeChordId((Object)successor, localId);
                        long xRelativeId = ChordUtil.relativeChordId((Object)x, localId);
                        if (xRelativeId > 0L && xRelativeId < successorRelativeId) {
                            LOG.debug("Successor's predecessor {} is closer then me. Use successor's predecessor as our new successor.", (Object)x);
                            return this.composableUpdateIthFinger(1, x, this.client);
                        }
                        return FutureComposer.composeSucceededFuture();
                    }
                    LOG.debug("Successor's predecessor is successor itself, notify successor to set us as his predecessor.");
                    if (!successor.equals(this.localAddress)) {
                        return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)successor).offerAsPredecessor());
                    }
                    return FutureComposer.composeSucceededFuture();
                });
            }
            return FutureComposer.composeSucceededFuture();
        }).finish((EventExecutor)this.group.next());
    }

    private FutureComposer<Void> fillSuccessor() {
        LOG.debug("Try to fill successor with candidates in finger table or even predecessor.");
        DrasylAddress successor = this.fingerTable.getSuccessor();
        FutureComposer future = successor == null || successor.equals(this.localAddress) ? this.findSuccessorStartingFromIthFinger(2) : FutureComposer.composeSucceededFuture();
        return future.then(() -> {
            DrasylAddress successor2 = this.fingerTable.getSuccessor();
            if ((successor2 == null || successor2.equals(this.localAddress)) && this.predecessor != null && !this.localAddress.equals(this.predecessor)) {
                return this.composableUpdateIthFinger(1, this.predecessor, this.client);
            }
            return FutureComposer.composeSucceededFuture();
        });
    }

    private FutureComposer<Void> findSuccessorStartingFromIthFinger(int i) {
        if (i <= 32) {
            DrasylAddress ithFinger = this.fingerTable.get(i);
            if (ithFinger != null && !ithFinger.equals(this.localAddress)) {
                return this.updateFingersFromIthToFirstFinger(i - 1, ithFinger);
            }
            return this.findSuccessorStartingFromIthFinger(i + 1);
        }
        return FutureComposer.composeSucceededFuture();
    }

    private FutureComposer<Void> updateFingersFromIthToFirstFinger(int j, DrasylAddress ithFinger) {
        if (j >= 1) {
            return this.composableUpdateIthFinger(j, ithFinger, this.client).then(() -> this.updateFingersFromIthToFirstFinger(j - 1, ithFinger));
        }
        return FutureComposer.composeSucceededFuture();
    }

    private FutureComposer<Void> deleteSuccessor() {
        DrasylAddress ithFinger;
        int i;
        DrasylAddress successor = this.fingerTable.getSuccessor();
        if (successor == null) {
            return FutureComposer.composeSucceededFuture();
        }
        for (i = 32; !(i <= 0 || (ithFinger = this.fingerTable.get(i)) != null && ithFinger.equals(successor)); --i) {
        }
        return this.deleteFromIthToFirstFinger(i).then(() -> {
            if (this.predecessor != null && Objects.equals(this.predecessor, this.fingerTable.getSuccessor())) {
                this.predecessor = null;
            }
            return this.fillSuccessor().then(() -> {
                DrasylAddress successor2 = this.fingerTable.getSuccessor();
                if ((successor2 == null || this.localAddress.equals(successor2)) && this.predecessor != null && !this.localAddress.equals(this.predecessor)) {
                    DrasylAddress predecessor1 = this.predecessor;
                    return this.findNewSuccessor(predecessor1, successor2).then(() -> this.composableUpdateIthFinger(1, predecessor1, this.client));
                }
                return FutureComposer.composeSucceededFuture();
            });
        });
    }

    private FutureComposer<Void> deleteFromIthToFirstFinger(int j) {
        return this.composableUpdateIthFinger(j, null, this.client).then(future -> {
            if (j > 1) {
                return this.deleteFromIthToFirstFinger(j - 1);
            }
            return this.composableUpdateIthFinger(j, null, this.client);
        });
    }

    private FutureComposer<DrasylAddress> findNewSuccessor(DrasylAddress peer, DrasylAddress successor) {
        return FutureComposer.composeFuture(this.client.lookup(BIND_NAME, RemoteChordNode.class, (SocketAddress)peer).getPredecessor()).then(future -> {
            DrasylAddress myPredecessor = (DrasylAddress)future.getNow();
            if (myPredecessor == null) {
                return FutureComposer.composeSucceededFuture((Object)peer);
            }
            if (myPredecessor.equals(peer) || myPredecessor.equals(this.localAddress) || myPredecessor.equals(successor)) {
                return FutureComposer.composeSucceededFuture((Object)peer);
            }
            return this.findNewSuccessor(myPredecessor, successor);
        });
    }

    public Future<Void> fixFinger(int i) {
        LOG.debug("fixFinger({})", (Object)i);
        long id = ChordUtil.ithFingerStart(this.localAddress, i);
        LOG.debug("Refresh {}th finger: Find successor for id `{}` ({}) and check if it is still the same peer.", new Supplier[]{() -> i, () -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id)});
        return this.composableFindSuccessor(id).then(future -> {
            if (future.isSuccess()) {
                DrasylAddress ithFinger = (DrasylAddress)future.getNow();
                LOG.debug("Successor for id `{}` ({}) is `{}`.", new Supplier[]{() -> ChordUtil.chordIdHex(id), () -> ChordUtil.chordIdPosition(id), () -> ithFinger});
                return this.composableUpdateIthFinger(i, ithFinger, this.client);
            }
            return FutureComposer.composeSucceededFuture();
        }).finish((EventExecutor)this.group.next());
    }

    public static interface IdentityPublicKeyMixin {
        @JsonValue
        public String toString();

        @JsonCreator
        public static DrasylAddress of(String bytes) {
            return null;
        }
    }

    @JsonDeserialize(as=IdentityPublicKey.class)
    public static interface DrasylAddressMixin {
    }
}

