/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.membership.cyclon;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.drasyl.handler.membership.cyclon.CyclonNeighbor;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.InconsistentSortedSet;
import org.drasyl.util.Pair;
import org.drasyl.util.Preconditions;
import org.drasyl.util.SetUtil;

public final class CyclonView {
    private final int capacity;
    private final SortedSet<CyclonNeighbor> neighbors;

    private CyclonView(int capacity, Set<CyclonNeighbor> neighbors) {
        this.capacity = Preconditions.requirePositive((int)capacity);
        this.neighbors = new InconsistentSortedSet(neighbors);
    }

    public String toString() {
        return "CyclonView{\n" + this.neighbors.stream().map(Object::toString).collect(Collectors.joining(",\n\t", "\t", "\n")) + "}";
    }

    public boolean isEmpty() {
        return this.neighbors.isEmpty();
    }

    public void increaseAgeByOne() {
        this.neighbors.forEach(CyclonNeighbor::increaseAgeByOne);
    }

    public Pair<CyclonNeighbor, Set<CyclonNeighbor>> highestAgeAndOtherRandomNeighbors(int n) {
        CyclonNeighbor highestAge = this.neighbors.last();
        List list = this.neighbors.stream().filter(neighbor -> !highestAge.equals(neighbor)).collect(Collectors.toCollection(LinkedList::new));
        Collections.shuffle(list);
        HashSet otherRandomNeighbors = new HashSet(list.subList(0, Math.min(list.size(), n)));
        return Pair.of((Object)highestAge, otherRandomNeighbors);
    }

    public Set<CyclonNeighbor> randomNeighbors(int n) {
        LinkedList<CyclonNeighbor> list = new LinkedList<CyclonNeighbor>(this.neighbors);
        Collections.shuffle(list);
        return new HashSet<CyclonNeighbor>(list.subList(0, Math.min(list.size(), n)));
    }

    public Set<CyclonNeighbor> getNeighbors() {
        return Set.copyOf(this.neighbors);
    }

    public void update(Set<CyclonNeighbor> fullReceivedNeighbors, Set<CyclonNeighbor> replaceCandidates) {
        CyclonNeighbor neighbor;
        Set receivedNeighbors = SetUtil.firstElements(fullReceivedNeighbors, (int)this.capacity);
        int replaceCount = Math.max(this.neighbors.size() + receivedNeighbors.size() - this.capacity, 0);
        InconsistentSortedSet sortedReplaceCandidates = new InconsistentSortedSet(Collections.reverseOrder());
        sortedReplaceCandidates.addAll(replaceCandidates);
        Iterator iterator = sortedReplaceCandidates.iterator();
        while (replaceCount > 0 && iterator.hasNext()) {
            neighbor = (CyclonNeighbor)iterator.next();
            if (!this.neighbors.remove(neighbor)) continue;
            --replaceCount;
        }
        while (replaceCount > 0) {
            neighbor = this.neighbors.last();
            if (!this.neighbors.remove(neighbor)) continue;
            --replaceCount;
        }
        this.neighbors.addAll(receivedNeighbors);
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean remove(CyclonNeighbor neighbor) {
        return this.neighbors.remove(neighbor);
    }

    public boolean add(CyclonNeighbor neighbor) {
        return this.neighbors.add(neighbor);
    }

    public static CyclonView of(int capacity, Set<CyclonNeighbor> neighbors) {
        return new CyclonView(capacity, neighbors);
    }

    public static CyclonView ofKeys(int capacity, Collection<DrasylAddress> neighbors) {
        return CyclonView.of(capacity, neighbors.stream().map(CyclonNeighbor::of).collect(Collectors.toSet()));
    }
}

