/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.monitoring;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.drasyl.handler.monitoring.TopologyHandler;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.InetSocketAddressUtil;
import org.drasyl.util.Preconditions;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class TelemetryHandler
extends TopologyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryHandler.class);
    private static final InetSocketAddress ZERO_IP = new InetSocketAddress("0.0.0.0", 0);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
    private final HttpClient httpClient;
    private final int submitIntervalSeconds;
    private final URI uri;
    private final boolean includeIp;
    private ScheduledFuture<?> submitJob;

    TelemetryHandler(Map<DrasylAddress, InetSocketAddress> superPeers, Map<DrasylAddress, InetSocketAddress> childrenPeers, Map<DrasylAddress, InetSocketAddress> peers, HttpClient httpClient, int submitIntervalSeconds, URI uri, boolean includeIp) {
        super(superPeers, childrenPeers, peers);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.submitIntervalSeconds = Preconditions.requirePositive((int)submitIntervalSeconds);
        this.uri = Objects.requireNonNull(uri);
        this.includeIp = includeIp;
        LOG.info("Telemetry enabled: submitIntervalSeconds={}s uri={} includeIp={}", new Object[]{submitIntervalSeconds, uri, includeIp});
    }

    public TelemetryHandler(int submitIntervalSeconds, URI uri, boolean includeIp) {
        this(new HashMap<DrasylAddress, InetSocketAddress>(), new HashMap<DrasylAddress, InetSocketAddress>(), new HashMap<DrasylAddress, InetSocketAddress>(), HTTP_CLIENT, submitIntervalSeconds, uri, includeIp);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.submitJob = ctx.executor().scheduleWithFixedDelay(() -> this.submitData(ctx), (long)this.submitIntervalSeconds, (long)this.submitIntervalSeconds, TimeUnit.SECONDS);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.submitJob != null) {
            this.submitJob.cancel(false);
        }
        ctx.fireChannelInactive();
    }

    private void submitData(ChannelHandlerContext ctx) {
        TopologyHandler.Topology topology = this.topology(ctx);
        if (!this.includeIp) {
            topology = TelemetryHandler.removeIpAddresses(topology);
        }
        String body = TelemetryHandler.serializeTopology(topology);
        HttpRequest request = HttpRequest.newBuilder(this.uri).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).timeout(Duration.ofSeconds(10L)).build();
        LOG.debug("Send current topology `{}` to `{}`", (Object)topology, (Object)this.uri);
        this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).exceptionally(e -> {
            LOG.warn("Unable to send topology to `{}`:", (Object)this.uri, e);
            return null;
        });
    }

    private static TopologyHandler.Topology removeIpAddresses(TopologyHandler.Topology topology) {
        return new TopologyHandler.Topology(topology.address(), topology.superPeers().keySet().stream().collect(Collectors.toMap(k -> k, k -> ZERO_IP)), topology.childrenPeers().keySet().stream().collect(Collectors.toMap(k -> k, k -> ZERO_IP)), topology.peers().keySet().stream().collect(Collectors.toMap(k -> k, k -> ZERO_IP)));
    }

    private static String serializeTopology(TopologyHandler.Topology topology) {
        return "{\"address\":\"" + topology.address() + "\",\"superPeers\":{" + TelemetryHandler.serializePeersMap(topology.superPeers()) + "},\"childrenPeers\":{" + TelemetryHandler.serializePeersMap(topology.childrenPeers()) + "},\"peers\":{" + TelemetryHandler.serializePeersMap(topology.peers()) + "}}";
    }

    private static String serializePeersMap(Map<DrasylAddress, InetSocketAddress> peers) {
        return peers.entrySet().stream().map(entry -> "\"" + ((DrasylAddress)entry.getKey()).toString() + "\":\"" + InetSocketAddressUtil.socketAddressToString((InetSocketAddress)((InetSocketAddress)entry.getValue())) + "\"").collect(Collectors.joining(","));
    }
}

