/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.monitoring;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.drasyl.handler.discovery.AddPathAndChildrenEvent;
import org.drasyl.handler.discovery.AddPathAndSuperPeerEvent;
import org.drasyl.handler.discovery.AddPathEvent;
import org.drasyl.handler.discovery.PathEvent;
import org.drasyl.handler.discovery.RemoveChildrenAndPathEvent;
import org.drasyl.handler.discovery.RemovePathEvent;
import org.drasyl.handler.discovery.RemoveSuperPeerAndPathEvent;
import org.drasyl.identity.DrasylAddress;

public abstract class TopologyHandler
extends ChannelInboundHandlerAdapter {
    protected final Map<DrasylAddress, InetSocketAddress> superPeers;
    protected final Map<DrasylAddress, InetSocketAddress> childrenPeers;
    protected final Map<DrasylAddress, InetSocketAddress> peers;

    protected TopologyHandler(Map<DrasylAddress, InetSocketAddress> superPeers, Map<DrasylAddress, InetSocketAddress> childrenPeers, Map<DrasylAddress, InetSocketAddress> peers) {
        this.superPeers = Objects.requireNonNull(superPeers);
        this.childrenPeers = Objects.requireNonNull(childrenPeers);
        this.peers = Objects.requireNonNull(peers);
    }

    protected TopologyHandler() {
        this(new HashMap<DrasylAddress, InetSocketAddress>(), new HashMap<DrasylAddress, InetSocketAddress>(), new HashMap<DrasylAddress, InetSocketAddress>());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof PathEvent) {
            PathEvent e = (PathEvent)evt;
            if (evt instanceof AddPathAndSuperPeerEvent) {
                this.superPeers.put(e.getAddress(), ((AddPathAndSuperPeerEvent)e).getInetAddress());
            } else if (evt instanceof RemoveSuperPeerAndPathEvent) {
                this.superPeers.remove(e.getAddress());
            } else if (evt instanceof AddPathAndChildrenEvent) {
                this.childrenPeers.put(e.getAddress(), ((AddPathAndChildrenEvent)e).getInetAddress());
            } else if (evt instanceof RemoveChildrenAndPathEvent) {
                this.childrenPeers.remove(e.getAddress());
            } else if (evt instanceof AddPathEvent) {
                this.peers.put(e.getAddress(), ((AddPathEvent)e).getInetAddress());
            } else if (evt instanceof RemovePathEvent) {
                this.peers.remove(e.getAddress());
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    protected Topology topology(ChannelHandlerContext ctx) {
        return new Topology((DrasylAddress)ctx.channel().localAddress(), this.superPeers, this.childrenPeers, this.peers);
    }

    public static class Topology {
        private final DrasylAddress address;
        private final Map<DrasylAddress, InetSocketAddress> superPeers;
        private final Map<DrasylAddress, InetSocketAddress> childrenPeers;
        private final Map<DrasylAddress, InetSocketAddress> peers;

        public Topology(DrasylAddress address, Map<DrasylAddress, InetSocketAddress> superPeers, Map<DrasylAddress, InetSocketAddress> childrenPeers, Map<DrasylAddress, InetSocketAddress> peers) {
            this.address = Objects.requireNonNull(address);
            this.superPeers = Objects.requireNonNull(superPeers);
            this.childrenPeers = Objects.requireNonNull(childrenPeers);
            this.peers = Objects.requireNonNull(peers);
        }

        public DrasylAddress address() {
            return this.address;
        }

        public Map<DrasylAddress, InetSocketAddress> superPeers() {
            return Map.copyOf(this.superPeers);
        }

        public Map<DrasylAddress, InetSocketAddress> childrenPeers() {
            return Map.copyOf(this.childrenPeers);
        }

        public Map<DrasylAddress, InetSocketAddress> peers() {
            return Map.copyOf(this.peers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Topology topology = (Topology)o;
            return Objects.equals(this.address, topology.address) && Objects.equals(this.superPeers, topology.superPeers) && Objects.equals(this.childrenPeers, topology.childrenPeers) && Objects.equals(this.peers, topology.peers);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.superPeers, this.childrenPeers, this.peers);
        }

        public String toString() {
            return "Topology{address=" + this.address + ", superPeers=" + this.superPeers.size() + ", childrenPeers=" + this.childrenPeers.size() + ", peers=" + this.peers.size() + "}";
        }
    }
}

