/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.rmi;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.drasyl.handler.rmi.RmiInvocationHandler;
import org.drasyl.handler.rmi.message.RmiError;
import org.drasyl.handler.rmi.message.RmiMessage;
import org.drasyl.handler.rmi.message.RmiResponse;
import org.drasyl.util.InternPool;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class RmiClientHandler
extends SimpleChannelInboundHandler<AddressedEnvelope<RmiMessage, SocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(RmiClientHandler.class);
    private final InternPool<Proxy> invocationHandlers = new InternPool();
    final Map<UUID, RmiInvocationHandler> requests;
    ChannelHandlerContext ctx;

    RmiClientHandler(Map<UUID, RmiInvocationHandler> requests) {
        super(false);
        this.requests = Objects.requireNonNull(requests);
    }

    public RmiClientHandler() {
        this(new HashMap<UUID, RmiInvocationHandler>());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.ctx = null;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof AddressedEnvelope && (((AddressedEnvelope)msg).content() instanceof RmiResponse || ((AddressedEnvelope)msg).content() instanceof RmiError);
    }

    protected void channelRead0(ChannelHandlerContext ctx, AddressedEnvelope<RmiMessage, SocketAddress> msg) {
        LOG.trace("Got `{}`.", msg);
        if (msg.content() instanceof RmiResponse) {
            this.handleResponse((RmiResponse)msg.content(), msg.sender());
        } else if (msg.content() instanceof RmiError) {
            this.handleError((RmiError)msg.content(), msg.sender());
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void handleResponse(RmiResponse response, SocketAddress sender) {
        UUID id = response.getId();
        ByteBuf result = response.getResult();
        RmiInvocationHandler invocationHandler = this.requests.remove(id);
        if (invocationHandler != null && invocationHandler.getAddress().equals(sender)) {
            invocationHandler.handleResult(id, result);
        }
    }

    private void handleError(RmiError error, SocketAddress sender) {
        UUID id = error.getId();
        String message = error.getMessage();
        RmiInvocationHandler invocationHandler = this.requests.remove(id);
        if (invocationHandler != null && invocationHandler.getAddress().equals(sender)) {
            invocationHandler.handleError(id, message);
        }
    }

    public <T> T lookup(String name, Class<T> clazz, SocketAddress address) {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new RmiInvocationHandler(this, clazz, name, address));
        return (T)this.invocationHandlers.intern((Object)((Proxy)proxy));
    }
}

