/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.rmi;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drasyl.handler.rmi.RmiClientHandler;
import org.drasyl.handler.rmi.RmiException;
import org.drasyl.handler.rmi.RmiUtil;
import org.drasyl.handler.rmi.annotation.RmiCacheResult;
import org.drasyl.handler.rmi.annotation.RmiTimeout;
import org.drasyl.handler.rmi.message.RmiCancel;
import org.drasyl.handler.rmi.message.RmiRequest;
import org.drasyl.util.ExpiringMap;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

class RmiInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RmiInvocationHandler.class);
    private static final Map<Method, Long> methodTimeouts = new HashMap<Method, Long>();
    private static final Map<Method, Long> methodResultCaches = new HashMap<Method, Long>();
    private final Class<?> clazz;
    private final RmiClientHandler handler;
    private final String name;
    private final SocketAddress address;
    private final Map<Method, Map<Integer, Optional<Object>>> resultsCache = new HashMap<Method, Map<Integer, Optional<Object>>>();
    private final Map<UUID, RemoteInvocation> requests = new HashMap<UUID, RemoteInvocation>();

    RmiInvocationHandler(RmiClientHandler handler, Class<?> clazz, String name, SocketAddress address) {
        this.handler = Objects.requireNonNull(handler);
        this.clazz = Objects.requireNonNull(clazz);
        this.name = Objects.requireNonNull(name);
        this.address = Objects.requireNonNull(address);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (args != null && args.length == 1 && "equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if ((args == null || args.length == 0) && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ((args == null || args.length == 0) && "toString".equals(method.getName())) {
            return this.toString();
        }
        if (method.getReturnType() != Void.TYPE && method.getReturnType() != Future.class) {
            throw new IllegalStateException("Method `" + method + "` must have return type `void` or `" + Future.class.getName() + "`.");
        }
        if (this.handler.ctx == null) {
            throw new IllegalStateException("You have to add " + StringUtil.simpleClassName((Object)((Object)this.handler)) + " to the channel pipeline first.");
        }
        int cacheKey = Objects.hashCode(args);
        Optional<Object> cachedResult = this.getCachedResult(method, cacheKey);
        if (cachedResult != null) {
            Object result = cachedResult.orElse(null);
            Supplier[] supplierArray = new Supplier[4];
            supplierArray[0] = method::getName;
            supplierArray[1] = () -> Arrays.stream(method.getParameterTypes()).map(StringUtil::simpleClassName).collect(Collectors.joining(","));
            supplierArray[2] = this::toString;
            supplierArray[3] = () -> StringUtil.simpleClassName((Object)result);
            LOG.debug("Reuse cached result for invocation `{}({})` on remote object `{}`: `{}`", supplierArray);
            return this.handler.ctx.executor().newSucceededFuture(result);
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = method::getName;
        supplierArray[1] = () -> Arrays.stream(method.getParameterTypes()).map(StringUtil::simpleClassName).collect(Collectors.joining(","));
        supplierArray[2] = () -> proxy;
        LOG.debug("Invoke `{}({})` on remote object `{}`.", supplierArray);
        Promise promise = this.handler.ctx.executor().newPromise();
        try {
            ByteBuf argsBuf = RmiUtil.marshalArgs(args, this.handler.ctx.alloc().buffer());
            this.performRemoteInvocation(method, (Promise<Object>)promise, argsBuf, cacheKey);
        }
        catch (IOException e) {
            promise.tryFailure((Throwable)new IllegalArgumentException(e));
        }
        return promise;
    }

    private void performRemoteInvocation(Method method, Promise<Object> promise, ByteBuf argsBuf, int cacheKey) {
        RmiRequest request = RmiRequest.of(this.name.hashCode(), RmiUtil.computeMethodHash(method), argsBuf);
        DefaultAddressedEnvelope msg = new DefaultAddressedEnvelope((Object)request, this.address);
        LOG.trace("Send `{}`.", (Object)msg);
        ChannelHandlerContext ctx = this.handler.ctx;
        ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.cause() != null) {
                LOG.warn("Error", future.cause());
                promise.tryFailure(future.cause());
            } else if (future.isCancelled()) {
                promise.cancel(false);
            } else if (method.getReturnType() == Void.TYPE) {
                promise.trySuccess(null);
            } else {
                this.requests.put(request.getId(), new RemoteInvocation(method, promise, cacheKey));
                this.handler.requests.put(request.getId(), this);
                promise.addListener(f -> {
                    this.handler.requests.remove(request.getId());
                    this.requests.remove(request.getId());
                });
                long timeoutMillis = RmiInvocationHandler.getMethodTimeout(method);
                if (timeoutMillis > 0L) {
                    ctx.executor().schedule(() -> promise.tryFailure((Throwable)new RmiException("Timeout! Got no response within " + timeoutMillis + "ms.")), timeoutMillis, TimeUnit.MILLISECONDS);
                }
            }
        }));
        promise.addListener((GenericFutureListener)((FutureListener)future -> {
            if (future.isCancelled()) {
                RmiCancel cancel = RmiCancel.of(request.getId());
                DefaultAddressedEnvelope msg1 = new DefaultAddressedEnvelope((Object)cancel, this.address);
                LOG.trace("Send `{}`.", (Object)msg1);
                ctx.writeAndFlush((Object)msg1);
            }
        }));
    }

    public void handleResult(UUID id, ByteBuf buf) {
        RemoteInvocation invocation = this.requests.remove(id);
        if (invocation != null) {
            Promise<Object> promise = invocation.getPromise();
            Method method = invocation.getMethod();
            Class<?> resultType = invocation.getReturnType();
            int cacheKey = invocation.getCacheKey();
            try {
                Object result = RmiUtil.unmarshalResult(resultType, buf);
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = method::getName;
                supplierArray[1] = () -> Arrays.stream(method.getParameterTypes()).map(StringUtil::simpleClassName).collect(Collectors.joining(","));
                supplierArray[2] = this::toString;
                supplierArray[3] = () -> StringUtil.simpleClassName((Object)result);
                LOG.debug("Invocation `{}({})` on remote object `{}` returned `{}`.", supplierArray);
                this.putCachedResult(method, cacheKey, result);
                promise.trySuccess(result);
            }
            catch (IOException e) {
                promise.tryFailure((Throwable)e);
            }
        }
    }

    void handleError(UUID id, String message) {
        RemoteInvocation invocation = this.requests.remove(id);
        if (invocation != null) {
            Promise<Object> promise = invocation.getPromise();
            LOG.warn("Got error: {}", (Object)message);
            promise.setFailure((Throwable)new RmiException(message));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.clazz.isAssignableFrom(o.getClass())) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address);
    }

    public String toString() {
        return this.name + "@" + this.address;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    private Optional<Object> getCachedResult(Method method, int key) {
        long expirationTime = RmiInvocationHandler.getMethodCacheResultTime(method);
        if (expirationTime > 0L) {
            Map resultCache = this.resultsCache.computeIfAbsent(method, m -> new ExpiringMap(1000L, expirationTime, 0L));
            return (Optional)resultCache.get(key);
        }
        return null;
    }

    private void putCachedResult(Method method, int key, Object result) {
        long expirationTime = RmiInvocationHandler.getMethodCacheResultTime(method);
        if (expirationTime > 0L) {
            Map resultCache = this.resultsCache.computeIfAbsent(method, m -> new ExpiringMap(1000L, expirationTime, 0L));
            resultCache.put(key, Optional.ofNullable(result));
        }
    }

    private static synchronized long getMethodCacheResultTime(Method method) {
        return methodResultCaches.computeIfAbsent(method, m -> {
            RmiCacheResult annotation = RmiInvocationHandler.getMethodAnnotation(RmiCacheResult.class, m);
            if (annotation != null) {
                return annotation.value();
            }
            return 0L;
        });
    }

    private static synchronized long getMethodTimeout(Method method) {
        return methodTimeouts.computeIfAbsent(method, m -> {
            RmiTimeout annotation = RmiInvocationHandler.getMethodAnnotation(RmiTimeout.class, m);
            if (annotation != null) {
                return annotation.value();
            }
            return 60000L;
        });
    }

    private static <T extends Annotation> T getMethodAnnotation(Class<T> annotation, Method method) {
        if (method.isAnnotationPresent(annotation)) {
            return method.getAnnotation(annotation);
        }
        if (method.getDeclaringClass().isAnnotationPresent(annotation)) {
            return method.getDeclaringClass().getAnnotation(annotation);
        }
        return null;
    }

    private static class RemoteInvocation {
        private final Promise<Object> promise;
        private final Method method;
        private final int cacheKey;

        RemoteInvocation(Method method, Promise<Object> promise, int cacheKey) {
            this.promise = Objects.requireNonNull(promise);
            this.method = Objects.requireNonNull(method);
            this.cacheKey = cacheKey;
        }

        public Promise<Object> getPromise() {
            return this.promise;
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getReturnType() {
            return (Class)((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
        }

        public int getCacheKey() {
            return this.cacheKey;
        }
    }
}

