/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.rmi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.drasyl.util.internal.UnstableApi;

public final class RmiUtil {
    @UnstableApi
    public static final ObjectMapper OBJECT_MAPPER = new CBORMapper();

    private RmiUtil() {
    }

    static void marshalValue(Object value, OutputStream out) throws IOException {
        OBJECT_MAPPER.writeValue(out, value);
    }

    static <T> T unmarshalValue(Class<T> type, InputStream in) throws IOException {
        return (T)OBJECT_MAPPER.readValue(in, type);
    }

    static ByteBuf marshalArgs(Object[] args, ByteBuf buf) throws IOException {
        try (ByteBufOutputStream out = new ByteBufOutputStream(buf);){
            RmiUtil.marshalValue(args, (OutputStream)out);
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
    }

    static Object unmarshalResult(Class<?> resultType, ByteBuf buf) throws IOException {
        try {
            Object obj;
            try (ByteBufInputStream in = new ByteBufInputStream(buf);){
                obj = RmiUtil.unmarshalValue(resultType, (InputStream)in);
            }
            return obj;
        }
        finally {
            buf.release();
        }
    }

    static ByteBuf marshalResult(Object result, ByteBuf buf) throws IOException {
        try (ByteBufOutputStream out = new ByteBufOutputStream(buf);){
            RmiUtil.marshalValue(result, (OutputStream)out);
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
    }

    static Object[] unmarshalArgs(Class<?>[] parameterTypes, ByteBuf buf) throws IOException {
        try {
            Object[] objectArray;
            try (ByteBufInputStream in = new ByteBufInputStream(buf);){
                Object[] args = RmiUtil.unmarshalValue(Object[].class, (InputStream)in);
                if (args == null) {
                    args = new Object[]{};
                }
                if (parameterTypes.length != args.length) {
                    throw new IOException("Expected " + parameterTypes.length + " arguments, but got " + args.length + " arguments.");
                }
                objectArray = args;
            }
            return objectArray;
        }
        finally {
            buf.release();
        }
    }

    public static int computeMethodHash(Method m) {
        Class<?>[] parameterTypes = m.getParameterTypes();
        Object[] values = new Object[1 + parameterTypes.length + 1];
        values[0] = m.getName();
        for (int i = 0; i < parameterTypes.length; ++i) {
            values[i + 1] = parameterTypes[i].getName();
        }
        values[values.length - 1] = m.getReturnType().getName();
        return Arrays.hashCode(values);
    }
}

