/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.rmi.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.util.Objects;
import java.util.UUID;
import org.drasyl.handler.rmi.message.RmiMessage;

public final class RmiRequest
extends DefaultByteBufHolder
implements RmiMessage {
    private final UUID id;
    private final int name;
    private final int method;

    private RmiRequest(UUID id, int name, int method, ByteBuf arguments) {
        super(arguments);
        this.id = Objects.requireNonNull(id);
        this.name = name;
        this.method = method;
    }

    public static RmiRequest of(UUID id, int name, int method, ByteBuf arguments) {
        return new RmiRequest(id, name, method, arguments);
    }

    public static RmiRequest of(int name, int method, ByteBuf arguments) {
        return RmiRequest.of(UUID.randomUUID(), name, method, arguments);
    }

    public UUID getId() {
        return this.id;
    }

    public int getName() {
        return this.name;
    }

    public int getMethod() {
        return this.method;
    }

    public ByteBuf getArguments() {
        return this.content();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RmiRequest that = (RmiRequest)o;
        return this.name == that.name && this.method == that.method && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.method, super.hashCode());
    }

    public String toString() {
        return "RmiRequest{id=" + this.id + ", name=" + this.name + ", method=" + this.method + ", arguments=" + this.getArguments() + "}";
    }
}

