/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.util.Objects;
import org.drasyl.handler.stream.LastMessageChunk;
import org.drasyl.handler.stream.MessageChunk;
import org.drasyl.util.Preconditions;
import org.drasyl.util.RandomUtil;

public class ChunkedMessageInput
implements ChunkedInput<MessageChunk> {
    private final ChunkedInput<ByteBuf> input;
    private final byte id;
    private int chunkNo;

    ChunkedMessageInput(ChunkedInput<ByteBuf> input, byte id, int chunkNo) {
        this.input = Objects.requireNonNull(input);
        this.id = id;
        this.chunkNo = Preconditions.requireNonNegative((int)chunkNo);
    }

    public ChunkedMessageInput(ChunkedInput<ByteBuf> input) {
        this(input, RandomUtil.randomByte(), 0);
    }

    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    public void close() throws Exception {
        this.input.close();
    }

    public MessageChunk readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public MessageChunk readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.input.isEndOfInput()) {
            return null;
        }
        ByteBuf buf = (ByteBuf)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        if (!this.input.isEndOfInput()) {
            MessageChunk chunk = new MessageChunk(this.id, this.chunkNo, buf);
            ++this.chunkNo;
            return chunk;
        }
        return new LastMessageChunk(this.id, this.chunkNo, buf);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

