/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.drasyl.handler.stream.LastMessageChunk;
import org.drasyl.handler.stream.MessageChunk;

@ChannelHandler.Sharable
public class MessageChunkDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private final int chunkNoFieldLength;

    public MessageChunkDecoder(int chunkNoFieldLength) {
        if (chunkNoFieldLength != 1 && chunkNoFieldLength != 2 && chunkNoFieldLength != 3) {
            throw new IllegalArgumentException("chunkNoFieldLength must be either 1, 2, or 3: " + chunkNoFieldLength);
        }
        this.chunkNoFieldLength = chunkNoFieldLength;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 6) {
            in.markReaderIndex();
            int magicNumber = in.readInt();
            byte id = in.readByte();
            if (-143591473 == magicNumber) {
                int chunkNo = this.getChunkNo(in);
                out.add((Object)new MessageChunk(id, chunkNo, in.retain()));
            } else if (-143591472 == magicNumber) {
                int totalChunks = this.getChunkNo(in);
                out.add((Object)new LastMessageChunk(id, totalChunks, in.retain()));
            } else {
                in.resetReaderIndex();
                out.add(in.retain());
            }
        } else {
            out.add(in.retain());
        }
    }

    private int getChunkNo(ByteBuf buf) {
        int chunkNo;
        switch (this.chunkNoFieldLength) {
            case 1: {
                chunkNo = buf.readUnsignedByte();
                break;
            }
            case 2: {
                chunkNo = buf.readUnsignedShort();
                break;
            }
            case 3: {
                chunkNo = buf.readUnsignedMedium();
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.chunkNoFieldLength + " (expected: 1, 2, or 3)");
            }
        }
        return chunkNo;
    }
}

