/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.drasyl.handler.stream.LastMessageChunk;
import org.drasyl.handler.stream.MessageChunk;

@ChannelHandler.Sharable
public class MessageChunkEncoder
extends MessageToByteEncoder<MessageChunk> {
    public static final int MAGIC_NUMBER_CONTENT = -143591473;
    public static final int MAGIC_NUMBER_LAST = -143591472;
    public static final int MIN_MESSAGE_LENGTH = 6;
    private final int chunkNoFieldLength;

    public MessageChunkEncoder(int chunkNoFieldLength) {
        if (chunkNoFieldLength != 1 && chunkNoFieldLength != 2 && chunkNoFieldLength != 3) {
            throw new IllegalArgumentException("chunkNoFieldLength must be either 1, 2, or 3: " + chunkNoFieldLength);
        }
        this.chunkNoFieldLength = chunkNoFieldLength;
    }

    protected void encode(ChannelHandlerContext ctx, MessageChunk msg, ByteBuf out) {
        if (msg instanceof LastMessageChunk) {
            out.writeInt(-143591472);
        } else {
            out.writeInt(-143591473);
        }
        out.writeByte((int)msg.msgId());
        switch (this.chunkNoFieldLength) {
            case 1: {
                if (msg.chunkNo() >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + msg.chunkNo());
                }
                out.writeByte((int)((byte)msg.chunkNo()));
                break;
            }
            case 2: {
                if (msg.chunkNo() >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + msg.chunkNo());
                }
                out.writeShort((int)((short)msg.chunkNo()));
                break;
            }
            case 3: {
                if (msg.chunkNo() >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + msg.chunkNo());
                }
                out.writeMedium(msg.chunkNo());
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        out.writeBytes(msg.content());
    }
}

