/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.DefaultByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.drasyl.handler.stream.LastMessageChunk;
import org.drasyl.handler.stream.MessageChunk;
import org.drasyl.handler.stream.MessageChunksBufferInputList;
import org.drasyl.util.Preconditions;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class MessageChunksBuffer
extends MessageToMessageDecoder<MessageChunk> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageChunksBuffer.class);
    private final int maxContentLength;
    private final int allChunksTimeout;
    private Byte id;
    private int contentLength;
    private final List<MessageChunk> chunks;
    private LastMessageChunk lastChunk;
    private ScheduledFuture<?> timeoutGuard;

    MessageChunksBuffer(int maxContentLength, int allChunksTimeout, List<MessageChunk> chunks, Byte id, int contentLength, LastMessageChunk lastChunk, ScheduledFuture<?> timeoutGuard) {
        this.maxContentLength = Preconditions.requirePositive((int)maxContentLength);
        this.allChunksTimeout = Preconditions.requireNonNegative((int)allChunksTimeout);
        this.chunks = Objects.requireNonNull(chunks);
        this.id = id;
        this.contentLength = Preconditions.requireNonNegative((int)contentLength);
        this.lastChunk = lastChunk;
        this.timeoutGuard = timeoutGuard;
    }

    public MessageChunksBuffer(int maxContentLength, int allChunksTimeout, int maxChunks) {
        this(maxContentLength, allChunksTimeout, new MessageChunksBufferInputList(maxChunks), null, 0, null, null);
    }

    protected void decode(ChannelHandlerContext ctx, MessageChunk msg, List<Object> out) throws Exception {
        if (this.id == null) {
            this.id = msg.msgId();
            if (this.allChunksTimeout > 0) {
                this.timeoutGuard = ctx.executor().schedule(() -> {
                    LOG.trace("Not all chunks have been received within {}ms. Discard {} chunks.", () -> this.allChunksTimeout, this.chunks::size);
                    this.discard();
                }, (long)this.allChunksTimeout, TimeUnit.MILLISECONDS);
            }
        }
        if (this.id.byteValue() == msg.msgId()) {
            this.contentLength += msg.content().readableBytes();
            if (this.contentLength > this.maxContentLength) {
                this.discard();
                throw new TooLongFrameException("The chunked ByteBuf has exhausted the max allowed size of " + this.maxContentLength + " bytes (tried to allocate additional " + (this.contentLength - this.maxContentLength) + " bytes).");
            }
            if (msg instanceof LastMessageChunk) {
                if (this.lastChunk == null) {
                    if (msg.chunkNo() < this.chunks.size()) {
                        this.discard();
                        throw new TooLongFrameException("More chunks received (" + this.chunks.size() + ") then specified in chunk header (" + msg.chunkNo() + ").");
                    }
                    this.lastChunk = (LastMessageChunk)msg.retain();
                }
            } else {
                this.chunks.set(msg.chunkNo(), (MessageChunk)msg.retain());
            }
            this.checkCompleteness(out);
        }
    }

    private void checkCompleteness(List<Object> out) {
        if (this.lastChunk != null && this.lastChunk.chunkNo() == this.chunks.size()) {
            if (this.timeoutGuard != null) {
                this.timeoutGuard.cancel(false);
            }
            out.addAll(this.chunks);
            out.add((Object)this.lastChunk);
            this.reset();
        }
    }

    private void reset() {
        this.id = null;
        this.contentLength = 0;
        this.chunks.clear();
        this.lastChunk = null;
        this.timeoutGuard = null;
    }

    private void discard() {
        this.chunks.forEach(DefaultByteBufHolder::release);
        this.reset();
    }
}

