/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.drasyl.util.Murmur3;

public class BloomFilter<E>
implements Set<E> {
    private static final int MURMUR_SEED1 = 1258387308;
    private static final int MURMUR_SEED2 = 2021488126;
    protected final Parameters parameters;
    protected final BitSet bitSet;
    protected final Function<E, byte[]> bytesSupplier;

    protected BloomFilter(Parameters parameters, Function<E, byte[]> bytesSupplier, BitSet bitSet) {
        this.parameters = Objects.requireNonNull(parameters);
        this.bytesSupplier = Objects.requireNonNull(bytesSupplier);
        this.bitSet = Objects.requireNonNull(bitSet);
    }

    protected BloomFilter(Parameters parameters, Function<E, byte[]> bytesSupplier) {
        this(parameters, bytesSupplier, new BitSet(parameters.m));
    }

    public BloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier, BitSet bitSet) {
        this(new Parameters(n, p, m, k), bytesSupplier, bitSet);
    }

    public BloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier) {
        this(new Parameters(n, p, m, k), bytesSupplier);
    }

    public BloomFilter(Integer n, Double p, Function<E, byte[]> bytesSupplier, BitSet bitSet) {
        this(n, p, 0, 0, bytesSupplier, bitSet);
    }

    public BloomFilter(Integer n, Double p, Function<E, byte[]> bytesSupplier) {
        this(n, p, 0, 0, bytesSupplier);
    }

    public String toString() {
        return "BloomFilter{n=" + this.parameters.n + ", p=" + this.parameters.p + ", m=" + this.parameters.m + ", k=" + this.parameters.k + "}";
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        try {
            int[] hashes;
            for (int hash : hashes = this.hashes(o)) {
                if (this.getBit(hash)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E element) {
        int[] hashes;
        boolean modified = false;
        for (int hash : hashes = this.hashes(element)) {
            if (!this.setBit(hash)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }

    public int n() {
        return this.parameters.n;
    }

    public double p() {
        return this.parameters.p;
    }

    public int m() {
        return this.parameters.m;
    }

    public int k() {
        return this.parameters.k;
    }

    public BitSet bitset() {
        return this.bitSet;
    }

    public void merge(BloomFilter<E> other) {
        if (!this.parameters.equals(other.parameters)) {
            throw new IllegalArgumentException("Bloom filters are incompatible");
        }
        this.bitSet.or(other.bitSet);
    }

    protected boolean getBit(int index) {
        return this.bitSet.get(index);
    }

    protected boolean setBit(int index) {
        boolean wasUnset;
        boolean bl = wasUnset = !this.getBit(index);
        if (wasUnset) {
            this.bitSet.set(index, true);
        }
        return wasUnset;
    }

    protected int[] hashes(E element) {
        byte[] bytes = this.bytesSupplier.apply(element);
        int hash1 = Murmur3.murmur3_x86_32((byte[])bytes, (int)1258387308);
        int hash2 = Murmur3.murmur3_x86_32((byte[])bytes, (int)2021488126);
        int[] hashes = new int[this.parameters.k];
        for (int i = 0; i < this.parameters.k; ++i) {
            hashes[i] = Math.abs(hash1 + i * hash2) % this.parameters.m;
        }
        return hashes;
    }

    protected static class Parameters {
        protected final int n;
        protected final double p;
        protected final int m;
        protected final int k;

        public Parameters(int n, double p, int m, int k) {
            if (n != 0 && p != 0.0 && m != 0 && k != 0) {
                throw new IllegalArgumentException("leave an attribute 0 so it can be dervied");
            }
            if (n == 0) {
                if (p == 0.0) {
                    throw new IllegalArgumentException("need p to derive n");
                }
                if (m == 0) {
                    throw new IllegalArgumentException("need m to derive n");
                }
                if (k == 0) {
                    throw new IllegalArgumentException("need k to derive n");
                }
                n = (int)Math.ceil((double)m / ((double)(-k) / Math.log(1.0 - Math.exp(Math.log(p) / (double)k))));
            } else if (p == 0.0) {
                if (m == 0) {
                    throw new IllegalArgumentException("need m to derive p");
                }
                if (k == 0) {
                    throw new IllegalArgumentException("need k to derive p");
                }
                p = Math.pow(1.0 - Math.exp(-k / (m / n)), k);
            } else {
                if (p <= 0.0 || p >= 1.0) {
                    throw new IllegalArgumentException("p must be a fraction between 0 and 1");
                }
                if (m == 0) {
                    m = (int)Math.ceil((double)n * Math.log(p) / Math.log(1.0 / Math.pow(2.0, Math.log(2.0))));
                }
            }
            if (k == 0) {
                k = (int)Math.round((double)(m / n) * Math.log(2.0));
            }
            this.n = n;
            this.p = p;
            this.m = m;
            this.k = k;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameters that = (Parameters)o;
            return this.n == that.n && Double.compare(that.p, this.p) == 0 && this.m == that.m && this.k == that.k;
        }

        public int hashCode() {
            return Objects.hash(this.n, this.p, this.m, this.k);
        }
    }
}

