/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.discover;

import app.moviebase.tmdb.discover.DiscoverCategory;
import app.moviebase.tmdb.model.TmdbDiscover;
import app.moviebase.tmdb.model.TmdbDiscoverMovieSortBy;
import app.moviebase.tmdb.model.TmdbDiscoverShowSortBy;
import app.moviebase.tmdb.model.TmdbDiscoverTimeRange;
import app.moviebase.tmdb.model.TmdbMediaType;
import app.moviebase.tmdb.model.TmdbReleaseType;
import app.moviebase.tmdb.remote.DateTimeExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\u0006\u00a8\u0006\u001b"}, d2={"Lapp/moviebase/tmdb/discover/DiscoverFactory;", "", "()V", "createAiringToday", "Lapp/moviebase/tmdb/model/TmdbDiscover$Show;", "createByCategory", "Lapp/moviebase/tmdb/model/TmdbDiscover;", "category", "Lapp/moviebase/tmdb/discover/DiscoverCategory;", "createForOneYear", "mediaType", "Lapp/moviebase/tmdb/model/TmdbMediaType;", "createNetwork", "network", "", "createNowPlaying", "Lapp/moviebase/tmdb/model/TmdbDiscover$Movie;", "createOnDvd", "createOnStreaming", "watchProviders", "", "watchRegion", "", "createOnTv", "createPopular", "createTopRated", "createUpcoming", "tmdb-api"})
public final class DiscoverFactory {
    @NotNull
    public static final DiscoverFactory INSTANCE = new DiscoverFactory();

    private DiscoverFactory() {
    }

    @NotNull
    public final TmdbDiscover createByCategory(@NotNull DiscoverCategory category) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        DiscoverCategory discoverCategory = category;
        if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.NowPlaying.INSTANCE)) {
            tmdbDiscover = this.createNowPlaying();
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.Upcoming.INSTANCE)) {
            tmdbDiscover = this.createUpcoming();
        } else if (discoverCategory instanceof DiscoverCategory.Popular) {
            tmdbDiscover = this.createPopular(((DiscoverCategory.Popular)category).getMediaType());
        } else if (discoverCategory instanceof DiscoverCategory.TopRated) {
            tmdbDiscover = this.createTopRated(((DiscoverCategory.TopRated)category).getMediaType());
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.AiringToday.INSTANCE)) {
            tmdbDiscover = this.createAiringToday();
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.OnTv.INSTANCE)) {
            tmdbDiscover = this.createOnTv();
        } else if (discoverCategory instanceof DiscoverCategory.OnDvd) {
            tmdbDiscover = this.createOnDvd(((DiscoverCategory.OnDvd)category).getMediaType());
        } else if (discoverCategory instanceof DiscoverCategory.Network) {
            tmdbDiscover = this.createNetwork(((DiscoverCategory.Network)category).getNetwork());
        } else if (discoverCategory instanceof DiscoverCategory.OnStreaming) {
            tmdbDiscover = this.createOnStreaming(((DiscoverCategory.OnStreaming)category).getMediaType(), ((DiscoverCategory.OnStreaming)category).getWatchProviders(), ((DiscoverCategory.OnStreaming)category).getWatchRegion());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover.Movie createNowPlaying() {
        LocalDate localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate firstDate = DateTimeExtensionsKt.minusWeeks(localDate, 6);
        LocalDate lastDate = DateTimeExtensionsKt.plusDays(localDate, 1);
        TmdbDiscoverTimeRange.Custom discoverTimeRange = new TmdbDiscoverTimeRange.Custom(firstDate.toString(), lastDate.toString());
        return new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, TmdbReleaseType.THEATRICAL, null, null, null, null, 31231, null);
    }

    @NotNull
    public final TmdbDiscover.Show createAiringToday() {
        String localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null).toString();
        return new TmdbDiscover.Show(null, null, null, null, null, null, null, null, null, localDate, localDate, null, null, null, null, null, null, 129535, null);
    }

    @NotNull
    public final TmdbDiscover.Show createOnTv() {
        LocalDate airDateGte = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate airDateLte = DateTimeExtensionsKt.plusWeeks(airDateGte, 2);
        return new TmdbDiscover.Show(null, null, null, null, null, null, null, null, null, airDateGte.toString(), airDateLte.toString(), null, null, null, null, null, null, 129535, null);
    }

    @NotNull
    public final TmdbDiscover createOnDvd(@NotNull TmdbMediaType mediaType) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                tmdbDiscover = new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.RELEASE_DATE, null, null, null, null, null, null, null, null, TmdbReleaseType.PHYSICAL, null, null, null, null, 31741, null);
                break;
            }
            case 2: {
                tmdbDiscover = new TmdbDiscover.Show(TmdbDiscoverShowSortBy.FIRST_AIR_DATE, null, null, null, null, null, null, null, null, null, null, null, TmdbReleaseType.PHYSICAL, null, null, null, null, 126974, null);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)mediaType) + " type is not supported for discover");
            }
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover createUpcoming() {
        LocalDate localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate firstDate = DateTimeExtensionsKt.plusDays(localDate, 2);
        LocalDate lastDate = DateTimeExtensionsKt.plusWeeks(localDate, 3);
        TmdbDiscoverTimeRange.Custom discoverTimeRange = new TmdbDiscoverTimeRange.Custom(firstDate.toString(), lastDate.toString());
        return new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, null, 32255, null);
    }

    @NotNull
    public final TmdbDiscover createPopular(@NotNull TmdbMediaType mediaType) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                tmdbDiscover = new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, null, 32765, null);
                break;
            }
            case 2: {
                tmdbDiscover = new TmdbDiscover.Show(TmdbDiscoverShowSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131070, null);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)mediaType) + " type is not supported for discover");
            }
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover createTopRated(@NotNull TmdbMediaType mediaType) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                tmdbDiscover = new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.VOTE_AVERAGE, null, null, null, 200, null, null, null, null, null, null, null, null, null, 32733, null);
                break;
            }
            case 2: {
                tmdbDiscover = new TmdbDiscover.Show(TmdbDiscoverShowSortBy.VOTE_AVERAGE, null, null, null, 200, null, null, null, null, null, null, null, null, null, null, null, null, 131054, null);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)mediaType) + " type is not supported for discover");
            }
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover.Show createNetwork(int network) {
        TmdbDiscoverShowSortBy tmdbDiscoverShowSortBy = TmdbDiscoverShowSortBy.POPULARITY;
        return new TmdbDiscover.Show(tmdbDiscoverShowSortBy, null, null, null, null, null, null, null, null, null, null, network, null, null, null, null, null, 129022, null);
    }

    @NotNull
    public final TmdbDiscover createOnStreaming(@NotNull TmdbMediaType mediaType, @NotNull List<Integer> watchProviders, @NotNull String watchRegion) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter(watchProviders, (String)"watchProviders");
        Intrinsics.checkNotNullParameter((Object)watchRegion, (String)"watchRegion");
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                tmdbDiscover = new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, watchProviders, watchRegion, null, 20477, null);
                break;
            }
            case 2: {
                tmdbDiscover = new TmdbDiscover.Show(TmdbDiscoverShowSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, null, watchProviders, watchRegion, null, 81918, null);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)mediaType) + " type is not supported for discover");
            }
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover createForOneYear(@NotNull TmdbMediaType mediaType) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        TmdbDiscoverTimeRange.OneYear discoverTimeRange = new TmdbDiscoverTimeRange.OneYear(DateTimeExtensionsKt.currentLocalDate$default(null, 1, null).getYear());
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                tmdbDiscover = new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, null, 32255, null);
                break;
            }
            case 2: {
                tmdbDiscover = new TmdbDiscover.Show(null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, null, null, null, null, 130815, null);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)mediaType) + " type is not supported for discover");
            }
        }
        return tmdbDiscover;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TmdbMediaType.values().length];
            nArray[TmdbMediaType.MOVIE.ordinal()] = 1;
            nArray[TmdbMediaType.SHOW.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

