/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.sentry.apachehttpclient4;

import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.drjekyll.sentry.apachehttpclient4.RequestHash;

public class SentryHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final IHub hub;

    public SentryHttpResponseInterceptor(IHub hub) {
        this.hub = (IHub)Args.notNull((Object)hub, (String)"Hub");
    }

    public void process(HttpResponse response, HttpContext context) {
        HttpRequestWrapper request;
        Args.notNull((Object)response, (String)"HTTP response");
        Args.notNull((Object)context, (String)"HTTP context");
        ISpan span = this.hub.getSpan();
        if (span == null) {
            return;
        }
        Object requestAttribute = context.getAttribute("http.request");
        if (requestAttribute instanceof HttpRequestWrapper && (request = (HttpRequestWrapper)requestAttribute).getOriginal() instanceof HttpUriRequest && SentryHttpResponseInterceptor.isCorrespondingSpan(span, (HttpUriRequest)request)) {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                int statusCode = statusLine.getStatusCode();
                span.setStatus(SpanStatus.fromHttpStatusCode((int)statusCode));
                HttpUriRequest original = (HttpUriRequest)request.getOriginal();
                this.hub.addBreadcrumb(Breadcrumb.http((String)original.getURI().toString(), (String)original.getMethod(), (Integer)statusCode));
            }
            span.finish();
        }
    }

    private static boolean isCorrespondingSpan(ISpan span, HttpUriRequest request) {
        Args.notNull((Object)span, (String)"Span");
        Args.notNull((Object)request, (String)"HTTP Request");
        if (!"http.client".equals(span.getOperation())) {
            return false;
        }
        Object requestHashData = span.getData("request.hash");
        return requestHashData != null && requestHashData.equals(RequestHash.create(request));
    }
}

