/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.sentry.apachehttpclient5;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.util.PropagationTargetsUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.drjekyll.sentry.apachehttpclient5.RequestHash;

public class SentryHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final IHub hub;

    public SentryHttpRequestInterceptor(@Nonnull IHub hub) {
        this.hub = (IHub)Args.notNull((Object)hub, (String)"Hub");
    }

    public void process(@Nonnull HttpRequest request, @Nullable EntityDetails entity, @Nullable HttpContext context) throws IOException {
        String url;
        Args.notNull((Object)request, (String)"HTTP request");
        ISpan activeSpan = this.hub.getSpan();
        String method = request.getMethod();
        try {
            url = request.getUri().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not read request URI", e);
        }
        if (activeSpan == null) {
            this.hub.addBreadcrumb(Breadcrumb.http((String)url, (String)method));
            return;
        }
        ISpan childSpan = activeSpan.startChild("http.client");
        try {
            childSpan.setData("request.hash", (Object)RequestHash.create(request));
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not create request hash", e);
        }
        childSpan.setDescription(String.format("%s %s", method, url));
        SentryTraceHeader sentryTraceHeader = childSpan.toSentryTrace();
        if (PropagationTargetsUtils.contain((List)this.hub.getOptions().getTracePropagationTargets(), (String)url)) {
            BaggageHeader baggageHeader;
            request.addHeader(sentryTraceHeader.getName(), (Object)sentryTraceHeader.getValue());
            Header[] headers = request.getHeaders("baggage");
            if (headers != null && (baggageHeader = childSpan.toBaggageHeader(((Stream)Arrays.stream(headers).sequential()).map(NameValuePair::getValue).collect(Collectors.toList()))) != null) {
                request.addHeader(baggageHeader.getName(), (Object)baggageHeader.getValue());
            }
        }
    }
}

