/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.sentry.apachehttpclient5;

import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.drjekyll.sentry.apachehttpclient5.RequestHash;

public class SentryHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final IHub hub;

    public SentryHttpResponseInterceptor(IHub hub) {
        this.hub = (IHub)Args.notNull((Object)hub, (String)"Hub");
    }

    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws IOException {
        Args.notNull((Object)response, (String)"HTTP response");
        Args.notNull((Object)context, (String)"HTTP context");
        ISpan span = this.hub.getSpan();
        if (span == null) {
            return;
        }
        Object requestAttribute = context.getAttribute("http.request");
        if (requestAttribute instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)requestAttribute;
            try {
                if (SentryHttpResponseInterceptor.isCorrespondingSpan(span, request)) {
                    int statusCode = response.getCode();
                    span.setStatus(SpanStatus.fromHttpStatusCode((int)statusCode));
                    this.hub.addBreadcrumb(Breadcrumb.http((String)request.getUri().toString(), (String)request.getMethod(), (Integer)statusCode));
                    span.finish();
                }
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not create request hash", e);
            }
        }
    }

    private static boolean isCorrespondingSpan(ISpan span, HttpRequest request) throws URISyntaxException {
        Args.notNull((Object)span, (String)"Span");
        Args.notNull((Object)request, (String)"HTTP Request");
        if (!"http.client".equals(span.getOperation())) {
            return false;
        }
        Object requestHashData = span.getData("request.hash");
        return requestHashData != null && requestHashData.equals(RequestHash.create(request));
    }
}

