/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.sentry.apachehttpclient4;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.util.PropagationTargetsUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.drjekyll.sentry.apachehttpclient4.RequestHash;

public class SentryHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final IHub hub;

    public SentryHttpRequestInterceptor(@Nonnull IHub hub) {
        this.hub = (IHub)Args.notNull((Object)hub, (String)"Hub");
    }

    public void process(HttpRequest request, HttpContext context) {
        Args.notNull((Object)request, (String)"HTTP request");
        if (!(request instanceof HttpRequestWrapper)) {
            return;
        }
        HttpRequestWrapper requestWrapper = (HttpRequestWrapper)request;
        if (!(requestWrapper.getOriginal() instanceof HttpUriRequest)) {
            return;
        }
        HttpUriRequest originalRequest = (HttpUriRequest)requestWrapper.getOriginal();
        ISpan activeSpan = this.hub.getSpan();
        String method = originalRequest.getMethod();
        String url = originalRequest.getURI().toString();
        if (activeSpan == null) {
            this.hub.addBreadcrumb(Breadcrumb.http((String)url, (String)method));
            return;
        }
        ISpan childSpan = activeSpan.startChild("http.client");
        childSpan.setData("request.hash", (Object)RequestHash.create((HttpUriRequest)requestWrapper));
        childSpan.setDescription(String.format("%s %s", method, url));
        SentryTraceHeader sentryTraceHeader = childSpan.toSentryTrace();
        if (PropagationTargetsUtils.contain((List)this.hub.getOptions().getTracePropagationTargets(), (String)url)) {
            BaggageHeader baggageHeader;
            request.addHeader(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
            Header[] headers = request.getHeaders("baggage");
            if (headers != null && (baggageHeader = childSpan.toBaggageHeader(((Stream)Arrays.stream(headers).sequential()).map(NameValuePair::getValue).collect(Collectors.toList()))) != null) {
                request.addHeader(baggageHeader.getName(), baggageHeader.getValue());
            }
        }
    }
}

