/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.sofa;

import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.config.UserThreadPoolManager;
import com.alipay.sofa.rpc.server.ServerFactory;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import com.alipay.sofa.rpc.server.http.AbstractHttpServer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.dromara.dynamictp.adapter.common.AbstractDtpAdapter;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SofaDtpAdapter
extends AbstractDtpAdapter {
    private static final Logger log = LoggerFactory.getLogger(SofaDtpAdapter.class);
    private static final String TP_PREFIX = "sofaTp";
    private static final String SERVER_CONFIG_FIELD = "serverConfig";
    private static final String USER_THREAD_FIELD = "userThreadMap";
    private static final String USER_THREAD_EXECUTOR_FIELD = "executor";
    private static final String BIZ_THREAD_POOL = "bizThreadPool";

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(dtpProperties.getSofaTp(), dtpProperties.getPlatforms());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    protected void initialize() {
        super.initialize();
        List servers = ServerFactory.getServers();
        boolean hasUserThread = UserThreadPoolManager.hasUserThread();
        if (CollectionUtils.isEmpty((Collection)servers) && !hasUserThread) {
            log.warn("Empty servers and empty user thread pools.");
            return;
        }
        servers.forEach(v -> {
            ThreadPoolExecutor executor = null;
            ServerConfig serverConfig = null;
            if (v instanceof BoltServer) {
                server = (BoltServer)v;
                executor = server.getBizThreadPool();
                serverConfig = (ServerConfig)ReflectionUtil.getFieldValue(BoltServer.class, (String)SERVER_CONFIG_FIELD, (Object)server);
            } else if (v instanceof AbstractHttpServer) {
                server = (AbstractHttpServer)v;
                executor = server.getBizThreadPool();
                serverConfig = (ServerConfig)ReflectionUtil.getFieldValue(AbstractHttpServer.class, (String)SERVER_CONFIG_FIELD, (Object)server);
            }
            if (Objects.isNull(executor) || Objects.isNull(serverConfig)) {
                return;
            }
            String tpName = "sofaTp#" + serverConfig.getProtocol() + "#" + serverConfig.getPort();
            this.enhanceOriginExecutor(tpName, executor, BIZ_THREAD_POOL, v);
        });
        if (hasUserThread) {
            this.handleUserThreadPools();
        }
    }

    private void handleUserThreadPools() {
        try {
            Field f = UserThreadPoolManager.class.getDeclaredField(USER_THREAD_FIELD);
            f.setAccessible(true);
            Map userThreadMap = (Map)f.get(null);
            if (MapUtils.isNotEmpty((Map)userThreadMap)) {
                userThreadMap.forEach((k, v) -> {
                    String tpName = "sofaTp#" + k;
                    this.enhanceOriginExecutor(tpName, v.getExecutor(), USER_THREAD_FIELD, v);
                });
            }
        }
        catch (Exception e) {
            log.warn("UserThreadPoolManager handles failed", (Throwable)e);
        }
    }
}

