/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.grpc;

import io.grpc.StatusRuntimeException;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.dromara.dynamictp.example.grpc.HelloReply;
import org.dromara.dynamictp.example.grpc.HelloRequest;
import org.dromara.dynamictp.example.grpc.SimpleGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GrpcClientService {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientService.class);
    @GrpcClient(value="cloud-grpc-server")
    private SimpleGrpc.SimpleBlockingStub simpleStub;

    public String sendMessage(String name) {
        try {
            HelloReply response = this.simpleStub.sayHello(HelloRequest.newBuilder().setName(name).build());
            return response.getMessage();
        }
        catch (StatusRuntimeException e) {
            log.error("Request failed", (Throwable)e);
            return "FAILED with " + e.getStatus().getCode();
        }
    }
}

