/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.grpc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ExperimentalApi;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import org.dromara.dynamictp.example.grpc.HelloReply;
import org.dromara.dynamictp.example.grpc.HelloRequest;

public class SimpleGrpc {
    public static final String SERVICE_NAME = "Simple";
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<HelloRequest, HelloReply> METHOD_SAY_HELLO = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"Simple", (String)"SayHello"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)HelloRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)HelloReply.getDefaultInstance()));
    private static final int METHODID_SAY_HELLO = 0;

    private SimpleGrpc() {
    }

    public static SimpleStub newStub(Channel channel) {
        return new SimpleStub(channel);
    }

    public static SimpleBlockingStub newBlockingStub(Channel channel) {
        return new SimpleBlockingStub(channel);
    }

    public static SimpleFutureStub newFutureStub(Channel channel) {
        return new SimpleFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_SAY_HELLO});
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final SimpleImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(SimpleImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.sayHello((HelloRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static final class SimpleFutureStub
    extends AbstractStub<SimpleFutureStub> {
        private SimpleFutureStub(Channel channel) {
            super(channel);
        }

        private SimpleFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleFutureStub build(Channel channel, CallOptions callOptions) {
            return new SimpleFutureStub(channel, callOptions);
        }

        public ListenableFuture<HelloReply> sayHello(HelloRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request);
        }
    }

    public static final class SimpleBlockingStub
    extends AbstractStub<SimpleBlockingStub> {
        private SimpleBlockingStub(Channel channel) {
            super(channel);
        }

        private SimpleBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleBlockingStub build(Channel channel, CallOptions callOptions) {
            return new SimpleBlockingStub(channel, callOptions);
        }

        public HelloReply sayHello(HelloRequest request) {
            return (HelloReply)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_SAY_HELLO, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class SimpleStub
    extends AbstractStub<SimpleStub> {
        private SimpleStub(Channel channel) {
            super(channel);
        }

        private SimpleStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleStub build(Channel channel, CallOptions callOptions) {
            return new SimpleStub(channel, callOptions);
        }

        public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class SimpleImplBase
    implements BindableService {
        public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_SAY_HELLO, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)SimpleGrpc.getServiceDescriptor()).addMethod(METHOD_SAY_HELLO, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).build();
        }
    }
}

