/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.OrderedDtpExecutor;
import org.dromara.dynamictp.core.support.DynamicTp;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.dromara.dynamictp.core.support.ThreadPoolCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfiguration.class);

    @DynamicTp(value="jucThreadPoolExecutor")
    @Bean
    public ThreadPoolExecutor jucThreadPoolExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    @DynamicTp(value="threadPoolTaskExecutor")
    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setTaskDecorator(r -> () -> {
            log.info("before execute");
            r.run();
            log.info("after execute");
        });
        return executor;
    }

    @Bean
    public DtpExecutor dtpExecutor0() {
        return ThreadPoolCreator.createDynamicFast((String)"dtpExecutor0");
    }

    @Bean
    public ThreadPoolExecutor dtpExecutor1() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("dtpExecutor1").threadFactory("test-dtp-common").corePoolSize(10).maximumPoolSize(15).keepAliveTime(40L).timeUnit(TimeUnit.SECONDS).workQueue(QueueTypeEnum.MEMORY_SAFE_LINKED_BLOCKING_QUEUE.getName(), Integer.valueOf(2000)).buildDynamic();
    }

    @Bean
    public DtpExecutor eagerDtpExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("eagerDtpExecutor").threadFactory("test-eager").corePoolSize(2).maximumPoolSize(4).queueCapacity(2000).eager().buildDynamic();
    }

    @Bean
    public OrderedDtpExecutor orderedDtpExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("orderedDtpExecutor").threadFactory("test-ordered").corePoolSize(4).maximumPoolSize(4).queueCapacity(2000).buildOrdered();
    }

    @Bean
    public ScheduledExecutorService scheduledDtpExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("scheduledDtpExecutor").corePoolSize(2).dynamic(true).threadFactory("test-scheduled").rejectedExecutionHandler(RejectedTypeEnum.CALLER_RUNS_POLICY.getName()).buildScheduled();
    }
}

