/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.core.support.DynamicTp;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.dromara.dynamictp.core.support.ThreadPoolCreator;
import org.dromara.dynamictp.core.thread.DtpExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThreadPoolConfiguration {
    @DynamicTp(value="commonExecutor")
    @Bean
    public ThreadPoolExecutor commonExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    @Bean
    public DtpExecutor dtpExecutor1() {
        return ThreadPoolCreator.createDynamicFast((String)"dtpExecutor1");
    }

    @Bean
    public DtpExecutor ioIntensiveExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("ioIntensiveExecutor").corePoolSize(20).maximumPoolSize(50).queueCapacity(2048).ioIntensive(true).buildDynamic();
    }

    @Bean
    public ThreadPoolExecutor dtpExecutor2() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("dtpExecutor2").corePoolSize(10).maximumPoolSize(15).keepAliveTime(15000L).timeUnit(TimeUnit.MILLISECONDS).workQueue(QueueTypeEnum.SYNCHRONOUS_QUEUE.getName(), null, Boolean.valueOf(false), null).waitForTasksToCompleteOnShutdown(true).awaitTerminationSeconds(5).buildDynamic();
    }
}

