/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.controller;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.support.task.runnable.NamedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Resource
    private ThreadPoolExecutor dtpExecutor1;

    @GetMapping(value={"/dtp-consul-example/test"})
    public String test() throws InterruptedException {
        this.task();
        return "success";
    }

    public void task() throws InterruptedException {
        Executor dtpExecutor2 = DtpRegistry.getExecutor((String)"dtpExecutor2");
        MDC.put((String)"traceId", (String)UUID.randomUUID().toString());
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            this.dtpExecutor1.execute(() -> log.info("i am dynamic-tp-test-1 task"));
            dtpExecutor2.execute((Runnable)NamedRunnable.of(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("i am dynamic-tp-test-2 task");
            }, (String)("task-" + i)));
        }
    }
}

