/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.OrderedDtpExecutor;
import org.dromara.dynamictp.core.support.DynamicTp;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.dromara.dynamictp.core.support.ThreadPoolCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfiguration {
    @DynamicTp(value="jucThreadPoolExecutor")
    @Bean
    public ThreadPoolExecutor jucThreadPoolExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    @DynamicTp(value="threadPoolTaskExecutor")
    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        return new ThreadPoolTaskExecutor();
    }

    @Bean
    public DtpExecutor dtpExecutor0() {
        return ThreadPoolCreator.createDynamicFast((String)"dtpExecutor0");
    }

    @Bean
    public ThreadPoolExecutor dtpExecutor1() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("dtpExecutor1").threadFactory("test-dtp-common").corePoolSize(10).maximumPoolSize(15).keepAliveTime(40L).timeUnit(TimeUnit.SECONDS).workQueue(QueueTypeEnum.MEMORY_SAFE_LINKED_BLOCKING_QUEUE.getName(), Integer.valueOf(2000)).buildDynamic();
    }

    @Bean
    public DtpExecutor eagerDtpExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("eagerDtpExecutor").threadFactory("test-eager").corePoolSize(2).maximumPoolSize(4).queueCapacity(2000).eager(true).buildDynamic();
    }

    @Bean
    public OrderedDtpExecutor orderedDtpExecutor() {
        return (OrderedDtpExecutor)ThreadPoolBuilder.newBuilder().threadPoolName("orderedDtpExecutor").threadFactory("test-ordered").corePoolSize(4).maximumPoolSize(4).queueCapacity(2000).ordered(true).buildDynamic();
    }

    @Bean
    public ScheduledExecutorService scheduledDtpExecutor() {
        return ThreadPoolBuilder.newBuilder().threadPoolName("scheduledDtpExecutor").corePoolSize(2).threadFactory("test-scheduled").rejectedExecutionHandler(RejectedTypeEnum.ABORT_POLICY.getName()).buildScheduled();
    }
}

