/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.jvmti;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.jvmti.JVMTIUtil;
import org.dromara.dynamictp.jvmti.NativeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMTI {
    private static final Logger log = LoggerFactory.getLogger(JVMTI.class);
    private static final AtomicBoolean AVAILABLE = new AtomicBoolean(false);

    private JVMTI() {
    }

    public static <T> T getInstance(Class<T> klass) {
        List<T> instances = JVMTI.getInstances(klass, 1);
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        if (instances.size() > 1) {
            throw new RuntimeException("expect only one instance, actually find many instances !");
        }
        return instances.get(0);
    }

    public static <T> List<T> getInstances(Class<T> klass) {
        return JVMTI.getInstances(klass, -1);
    }

    public static <T> List<T> getInstances(Class<T> klass, int limit) {
        if (!AVAILABLE.get()) {
            return Collections.emptyList();
        }
        return Arrays.asList(JVMTI.getInstances0(klass, limit));
    }

    private static synchronized native <T> T[] getInstances0(Class<T> var0, int var1);

    public static synchronized native void forceGc();

    static {
        try {
            NativeUtil.loadLibraryFromJar(JVMTIUtil.detectLibName());
            AVAILABLE.set(true);
        }
        catch (Throwable t) {
            log.error("JVMTI initialization failed!", t);
        }
    }
}

