/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.myth.dubbo.proxy;

import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.proxy.InvokerInvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.dromara.myth.annotation.Myth;
import org.dromara.myth.common.bean.context.MythTransactionContext;
import org.dromara.myth.common.bean.entity.MythInvocation;
import org.dromara.myth.common.bean.entity.MythParticipant;
import org.dromara.myth.common.exception.MythRuntimeException;
import org.dromara.myth.common.utils.DefaultValueUtils;
import org.dromara.myth.core.concurrent.threadlocal.TransactionContextLocal;
import org.dromara.myth.core.helper.SpringBeanUtils;
import org.dromara.myth.core.service.engine.MythTransactionEngine;

public class MythInvokerInvocationHandler
extends InvokerInvocationHandler {
    private Object target;

    public MythInvokerInvocationHandler(Invoker<?> handler) {
        super(handler);
    }

    public <T> MythInvokerInvocationHandler(T target, Invoker<T> invoker) {
        super(invoker);
        this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Myth myth = method.getAnnotation(Myth.class);
        Class[] arguments = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        if (Objects.nonNull(myth)) {
            MythTransactionContext mythTransactionContext = TransactionContextLocal.getInstance().get();
            try {
                MythParticipant participant = this.buildParticipant(mythTransactionContext, myth, method, clazz, args, arguments);
                if (Objects.nonNull(participant)) {
                    MythTransactionEngine mythTransactionEngine = (MythTransactionEngine)SpringBeanUtils.getInstance().getBean(MythTransactionEngine.class);
                    mythTransactionEngine.registerParticipant(participant);
                }
                return super.invoke(this.target, method, args);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return DefaultValueUtils.getDefaultValue(method.getReturnType());
            }
        }
        return super.invoke(this.target, method, args);
    }

    private MythParticipant buildParticipant(MythTransactionContext mythTransactionContext, Myth myth, Method method, Class clazz, Object[] arguments, Class ... args) throws MythRuntimeException {
        if (Objects.nonNull(mythTransactionContext)) {
            MythInvocation mythInvocation = new MythInvocation(clazz, method.getName(), args, arguments);
            String destination = myth.tags().length() > 0 ? myth.destination() + "," + myth.tags() : myth.destination();
            Integer pattern = myth.pattern().getCode();
            return new MythParticipant(mythTransactionContext.getTransId(), destination, pattern, mythInvocation);
        }
        return null;
    }
}

