/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.model.waltz;

import org.drools.benchmark.model.waltz.Junction;

public class WaltzUtil {
    private static double PI = 3.1415927;
    private static final int MOD_NUM = 10000;

    private static int get_y(int val) {
        return val % 10000;
    }

    private static int get_x(int val) {
        return val / 10000;
    }

    private static double get_angle(int p1, int p2) {
        double ret = 0.0;
        int delta_x = WaltzUtil.get_x(p2) - WaltzUtil.get_x(p1);
        int delta_y = WaltzUtil.get_y(p2) - WaltzUtil.get_y(p1);
        if (delta_x == 0) {
            if (delta_y > 0) {
                ret = PI / 2.0;
            } else if (delta_y < 0) {
                ret = -PI / 2.0;
            }
        } else if (delta_y == 0) {
            if (delta_x > 0) {
                ret = 0.0;
            } else if (delta_x < 0) {
                ret = PI;
            }
        } else {
            ret = Math.atan2(delta_y, delta_x);
        }
        return ret;
    }

    private static double inscribed_angle(int basepoint, int p1, int p2) {
        double angle2;
        double angle1 = WaltzUtil.get_angle(basepoint, p1);
        double temp = angle1 - (angle2 = WaltzUtil.get_angle(basepoint, p2));
        if (temp < 0.0) {
            temp = -temp;
        }
        if (temp > PI) {
            temp = 2.0 * PI - temp;
        }
        if (temp < 0.0) {
            return -temp;
        }
        return temp;
    }

    public static Junction make_3_junction(int basepoint, int p1, int p2, int p3) {
        int barb2;
        int barb1;
        int shaft;
        double sum;
        double angle12 = WaltzUtil.inscribed_angle(basepoint, p1, p2);
        double angle13 = WaltzUtil.inscribed_angle(basepoint, p1, p3);
        double angle23 = WaltzUtil.inscribed_angle(basepoint, p2, p3);
        double sum1213 = angle12 + angle13;
        double sum1223 = angle12 + angle23;
        double sum1323 = angle13 + angle23;
        if (sum1213 < sum1223) {
            if (sum1213 < sum1323) {
                sum = sum1213;
                shaft = p1;
                barb1 = p2;
                barb2 = p3;
            } else {
                sum = sum1323;
                shaft = p3;
                barb1 = p1;
                barb2 = p2;
            }
        } else if (sum1223 < sum1323) {
            sum = sum1223;
            shaft = p2;
            barb1 = p1;
            barb2 = p3;
        } else {
            sum = sum1323;
            shaft = p3;
            barb1 = p1;
            barb2 = p2;
        }
        double delta = sum - PI;
        if (delta < 0.0) {
            delta = -delta;
        }
        String j_type = delta < 0.001 ? Junction.TEE : (sum > PI ? Junction.FORK : Junction.ARROW);
        return new Junction(barb1, shaft, barb2, basepoint, j_type);
    }
}

